#if 0
//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * VF[_}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Shader/ShaderManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Shader/ShaderManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* ShaderManagerTest::suite(){
	TestSuite* suite = new TestSuite("ShaderManagerTest");
	suite->addTest(new TestCaller(ShaderManagerTest, testConstructor));
	suite->addTest(new TestCaller(ShaderManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void ShaderManagerTest::testConstructor(){
	TestEquals(44, (int)sizeof(ShaderManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	ShaderManager* manager = scene->getShaderManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void ShaderManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	ShaderManager* manager = scene->getShaderManager();
	// f[^x[X̍\z
	int shaderCount = 257;
	String* names = new String[shaderCount];
	Shader** shaders = new Shader*[shaderCount];
	for(int i = 0; i < shaderCount; i++){
		names[i].format("shader%d", i);
	}
	for(int i = 0; i < shaderCount; i++){
		shaders[i] = manager->createLambertShader(names[i]);
	}
	// zANZX
	TestEquals(shaderCount, manager->getCount());
	for(int i = 0; i < shaderCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(shaders[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < shaderCount; i++){
		Shader* shader = manager->search(names[i]);
		TestAssert(shader == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(shaders[i]));
	}
	// NA
	TestEquals(shaderCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] shaders;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
#endif
