#if 0
//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * o[gVF[_̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Shader/LambertShaderTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Shader/ShaderManager.h"
#include "Graphics/Mesh/MeshManager.h"
#include "Graphics/Texture/TextureManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* LambertShaderTest::suite(){
	TestSuite* suite = new TestSuite("LambertShaderTest");
	suite->addTest(new TestCaller(LambertShaderTest, testShaderData));
	suite->addTest(new TestCaller(LambertShaderTest, testAlphaData));
	suite->addTest(new TestCaller(LambertShaderTest, testData));
	suite->addTest(new TestCaller(LambertShaderTest, testReference));
	suite->addTest(new TestCaller(LambertShaderTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// VF[_f[^eXg
void LambertShaderTest::testShaderData(){
	Scene* scene = LampGraphics::createScene("test");
	ShaderManager* manager = scene->getShaderManager();
	LambertShader* shader0 = manager->createLambertShader("shader0");
	TestAssert(shader0->isShader());
	// Z
	TestAssert(shader0->useZWrite());
	shader0->setZWrite(false);
	TestAssert(!shader0->useZWrite());
	// ZeXg
	TestAssert(shader0->useZTest());
	shader0->setZTest(false);
	TestAssert(!shader0->useZTest());
	// tHO
	TestAssert(shader0->useFog());
	shader0->setFog(false);
	TestAssert(!shader0->useFog());
	// tHO
	TestAssert(!shader0->useBlackFog());
	shader0->setBlackFog(true);
	TestAssert(shader0->useBlackFog());

	// n
	manager->destroy(shader0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// At@f[^eXg
void LambertShaderTest::testAlphaData(){
//	TestEquals(28, (int)sizeof(Shader));
//	TestEquals(44, (int)sizeof(AlphaShader));
	Scene* scene = LampGraphics::createScene("test");
	ShaderManager* manager = scene->getShaderManager();
	LambertShader* shader0 = manager->createLambertShader("shader0");
	TestAssert(shader0->isAlphaShader());
	TestAssert(shader0->castAlphaShader() != NULL);
	// At@ufBO
	TestAssert(!shader0->useAlphaBlend());
	shader0->setAlphaBlend(true);
	TestAssert(shader0->useAlphaBlend());
	// At@l
	TestEquals(1.f, shader0->getAlpha());
	shader0->setAlpha(12.34f);
	TestEquals(12.34f, shader0->getAlpha());
	// uh\[X
	TestEquals(AlphaShader::bsZero, shader0->getBlendSource());
	TestEquals("Zero", AlphaShader::blendSourceToString(AlphaShader::bsZero));
	shader0->setBlendSource(AlphaShader::bsOne);
	TestEquals(AlphaShader::bsOne, shader0->getBlendSource());
	TestEquals("DestinationColor",
		AlphaShader::blendSourceToString(AlphaShader::bsDestinationColor));
	TestAssert(AlphaShader::bsDestinationColor ==
		AlphaShader::blendSourceFromString("DestinationColor"));
	// uhfXeBl[V
	TestEquals(AlphaShader::bdZero, shader0->getBlendDestination());
	TestEquals("Zero",
		AlphaShader::blendDestinationToString(AlphaShader::bdZero));
	shader0->setBlendDestination(AlphaShader::bdOne);
	TestEquals(AlphaShader::bdOne, shader0->getBlendDestination());
	TestEquals("SourceColor",
		AlphaShader::blendDestinationToString(AlphaShader::bdSourceColor));
	TestAssert(AlphaShader::bdSourceColor ==
		AlphaShader::blendDestinationFromString("SourceColor"));
	// n
	manager->destroy(shader0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^eXg
void LambertShaderTest::testData(){
//	TestEquals(84, (int)sizeof(LambertShader));
	Scene* scene = LampGraphics::createScene("test");
	ShaderManager* manager = scene->getShaderManager();
	LambertShader* shader0 = manager->createLambertShader("shader0");
	TestAssert(shader0->isLambertShader());
	TestAssert(shader0->castLambertShader() != NULL);
	TestAssert(shader0->supportedBaseTexture());
	// O
	TestEquals("shader0", shader0->getName());
	// fBt[YJ[
	TestAssert(Color3f(1.f, 1.f, 1.f) == shader0->getDiffuseColor());
	shader0->setDiffuseColor(Color3f(0.1f, 0.2f, 0.3f));
	TestAssert(Color3f(0.1f, 0.2f, 0.3f) == shader0->getDiffuseColor());
	// ArGgJ[
	TestAssert(Color3f(1.f, 1.f, 1.f) == shader0->getAmbientColor());
	shader0->setAmbientColor(Color3f(0.2f, 0.3f, 0.4f));
	TestAssert(Color3f(0.2f, 0.3f, 0.4f) == shader0->getAmbientColor());
	// G~bVuJ[
	TestAssert(Color3f(0.f, 0.f, 0.f) == shader0->getEmissiveColor());
	shader0->setEmissiveColor(Color3f(0.3f, 0.4f, 0.5f));
	TestAssert(Color3f(0.3f, 0.4f, 0.5f) == shader0->getEmissiveColor());
	// n
	manager->destroy(shader0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void LambertShaderTest::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	ShaderManager* manager = scene->getShaderManager();
	LambertShader* shader0 = manager->createLambertShader("shader0");

	// ڂ̃bV֒ǉ
	TestEquals(0, shader0->getParentCount());
	MeshManager* meshManager = scene->getMeshManager();
	RigidMesh* mesh0 = meshManager->createRigidMesh("mesh0");
	TestAssert(mesh0->getShader() == NULL);
	mesh0->setShader(shader0);
	TestAssert(mesh0->getShader() == shader0);
	TestEquals(1, shader0->getParentCount());
	// ڂ̃bV֒ǉ
	RigidMesh* mesh1 = meshManager->createRigidMesh("mesh1");
	mesh1->setShader(shader0);
	TestEquals(2, shader0->getParentCount());
	TestAssert(shader0->getParent(0) == mesh0);
	TestAssert(shader0->getParent(1) == mesh1);
	TestEquals(2, manager->destroy(shader0));
	// ڂ̃bV폜
	mesh0->removeShader();
	TestAssert(mesh0->getShader() == NULL);
	TestEquals(1, shader0->getParentCount());
	TestEquals(1, manager->destroy(shader0));
	// ڂ̃bV폜
	mesh1->setShader(NULL);
	TestAssert(mesh1->getShader() == NULL);
	TestEquals(0, shader0->getParentCount());
	meshManager->destroy(mesh0);
	meshManager->destroy(mesh1);

	// n
	TestEquals(0, manager->destroy(shader0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void LambertShaderTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	ShaderManager* manager = scene->getShaderManager();
	LambertShader* shader0 = manager->createLambertShader("shader0");
	shader0->setAlphaBlend(true);
	shader0->setAlpha(12.34f);
	shader0->setBlendSource(AlphaShader::bsOne);
	shader0->setBlendDestination(AlphaShader::bdOne);
	shader0->setDiffuseColor(Color3f(0.1f, 0.2f, 0.3f));
	shader0->setAmbientColor(Color3f(0.2f, 0.3f, 0.4f));
	shader0->setEmissiveColor(Color3f(0.3f, 0.4f, 0.5f));
	TextureManager* textureManager = scene->getTextureManager();
	Texture* texture = textureManager->createSurfaceTexture("tex0");
	shader0->setBaseTexture(texture);

	LambertShader* shader1 = shader0->copyLambertShader(0);
	TestEquals("shader0_0", shader1->getName());
	TestAssert(shader1->useAlphaBlend());
	TestEquals(12.34f, shader1->getAlpha());
	TestEquals(AlphaShader::bsOne, shader1->getBlendSource());
	TestEquals(AlphaShader::bdOne, shader1->getBlendDestination());
	TestAssert(Color3f(0.1f, 0.2f, 0.3f) == shader1->getDiffuseColor());
	TestAssert(Color3f(0.2f, 0.3f, 0.4f) == shader1->getAmbientColor());
	TestAssert(Color3f(0.3f, 0.4f, 0.5f) == shader1->getEmissiveColor());
	TestEquals("tex0", shader1->getBaseTexture()->getName());

	// n
	TestEquals(3, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
#endif
