//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[h̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/SceneNode/SceneNodeTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/SceneNode/SceneNodeManager.h"
#include "Graphics/Model/ModelManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* SceneNodeTest::suite(){
	TestSuite* suite = new TestSuite("SceneNodeTest");
	suite->addTest(new TestCaller(SceneNodeTest, testData));
	suite->addTest(new TestCaller(SceneNodeTest, testReference));
	suite->addTest(new TestCaller(SceneNodeTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void SceneNodeTest::testData(){
//	TestEquals(96, (int)sizeof(SceneNode));
	Scene* scene = LampGraphics::createScene("test");
	SceneNodeManager* manager = scene->getSceneNodeManager();
	SceneNode* sceneNode0 = manager->createSceneNode("sceneNode0");
	TestAssert(sceneNode0->isSceneNode());
	// O
	TestEquals("sceneNode0", sceneNode0->getName());
	// XP[
	TestAssert(Vector3(1.f, 1.f, 1.f) == sceneNode0->getScale());
	TestAssert(!sceneNode0->isScaled());
	sceneNode0->setScale(Vector3(0.f, 0.f, 0.f));
	TestAssert(Vector3(0.f, 0.f, 0.f) == sceneNode0->getScale());
	TestAssert(sceneNode0->isScaled());
	// ]
	TestAssert(Vector3(0.f, 0.f, 0.f) == sceneNode0->getRotationXYZ());
	sceneNode0->setRotationXYZ(Vector3(1.f, 1.f, 1.f));
	TestAssert(Vector3(1.f, 1.f, 1.f) == sceneNode0->getRotationXYZ());
	// ړ
	TestAssert(Vector3(0.f, 0.f, 0.f) == sceneNode0->getTranslation());
	sceneNode0->setTranslation(Vector3(1.f, 1.f, 1.f));
	TestAssert(Vector3(1.f, 1.f, 1.f) == sceneNode0->getTranslation());
	// LAtO
	TestAssert(sceneNode0->isEnabled());
	sceneNode0->setEnabled(false);
	TestAssert(!sceneNode0->isEnabled());
	// n
	manager->destroy(sceneNode0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void SceneNodeTest::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	SceneNodeManager* manager = scene->getSceneNodeManager();
	SceneNode* sceneNode0 = manager->createSceneNode("sceneNode0");

	// V[m[h֒ǉ
	TestAssert(sceneNode0->getParent() == NULL);
	SceneNode* sceneNode1 = manager->createSceneNode("sceneNode1");
	sceneNode0->addSceneNode(sceneNode1);
	TestEquals(1, sceneNode0->getSceneNodeCount());
	TestAssert(sceneNode1 == sceneNode0->getSceneNode(0));
	SceneNode* sceneNode2 = manager->createSceneNode("sceneNode2");
	sceneNode0->addSceneNode(sceneNode2);
	TestEquals(2, sceneNode0->getSceneNodeCount());
	TestAssert(sceneNode2 == sceneNode0->getSceneNode(1));
	TestEquals(1, manager->destroy(sceneNode1));
	sceneNode0->removeSceneNode(sceneNode1);
	TestEquals(0, manager->destroy(sceneNode1));
	TestEquals(1, manager->destroy(sceneNode2));
	sceneNode0->removeSceneNode(sceneNode2);
	TestEquals(0, manager->destroy(sceneNode2));
	TestEquals(0, manager->destroy(sceneNode0));

	// n
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void SceneNodeTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	SceneNodeManager* manager = scene->getSceneNodeManager();
	SceneNode* sceneNode0 = manager->createSceneNode("sceneNode0");
	sceneNode0->setScale(Vector3(0.f, 0.f, 0.f));
	sceneNode0->setRotationXYZ(Vector3(1.f, 1.f, 1.f));
	sceneNode0->setTranslation(Vector3(1.f, 1.f, 1.f));
	sceneNode0->setEnabled(false);
	SceneNode* sceneNode1 = manager->createSceneNode("sceneNode1");
	sceneNode0->addSceneNode(sceneNode1);
	ModelManager* modelManager = scene->getModelManager();
	StandardModel* model0 = modelManager->createStandardModel("model0");
	sceneNode0->addSceneLeaf(model0);

	SceneNode* copyNode = sceneNode0->copy(0);
	TestEquals("sceneNode0_0", copyNode->getName());
	TestAssert(Vector3(0.f, 0.f, 0.f) == copyNode->getScale());
	TestAssert(Vector3(1.f, 1.f, 1.f) == copyNode->getRotationXYZ());
	TestAssert(Vector3(1.f, 1.f, 1.f) == copyNode->getTranslation());
	TestAssert(!copyNode->isEnabled());
	TestEquals(1, copyNode->getSceneNodeCount());
	TestEquals("sceneNode1_0", copyNode->getSceneNode(0)->getName());
	TestEquals(1, copyNode->getSceneLeafCount());
	TestEquals("model0_0", copyNode->getSceneLeaf(0)->getName());

	// n
	TestEquals(3, SceneNode::recursiveDestroy(copyNode));
	TestEquals(3, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
