//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[h}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/SceneNode/SceneNodeManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/SceneNode/SceneNodeManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* SceneNodeManagerTest::suite(){
	TestSuite* suite = new TestSuite("SceneNodeManagerTest");
	suite->addTest(new TestCaller(SceneNodeManagerTest, testConstructor));
	suite->addTest(new TestCaller(SceneNodeManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void SceneNodeManagerTest::testConstructor(){
	TestEquals(40, (int)sizeof(SceneNodeManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	SceneNodeManager* manager = scene->getSceneNodeManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void SceneNodeManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	SceneNodeManager* manager = scene->getSceneNodeManager();
	// f[^x[X̍\z
	int sceneNodeCount = 257;
	String* names = new String[sceneNodeCount];
	SceneNode** sceneNodes = new SceneNode*[sceneNodeCount];
	for(int i = 0; i < sceneNodeCount; i++){
		names[i].format("sceneNode%d", i);
	}
	for(int i = 0; i < sceneNodeCount; i++){
		sceneNodes[i] = manager->createSceneNode(names[i]);
	}
	// zANZX
	TestEquals(sceneNodeCount + 1, manager->getCount());
	for(int i = 0; i < sceneNodeCount; i++){
		TestEquals(names[i], manager->get(i + 1)->getName());
		TestAssert(sceneNodes[i] == manager->get(i + 1));
	}
	// ANZX
	for(int i = 0; i < sceneNodeCount; i++){
		SceneNode* sceneNode = manager->search(names[i]);
		TestAssert(sceneNode == manager->get(i + 1));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(sceneNodes[i]));
	}
	// NA
	TestEquals(sceneNodeCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] sceneNodes;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
