//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * sN`pXύXtB^̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/SceneFilter/ChangePicturePathFilterTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Picture/PictureManager.h"
#include "Graphics/SceneFilter/SceneFilter.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* ChangePicturePathFilterTest::suite(){
	TestSuite* suite = new TestSuite("ChangePicturePathFilterTest");
	suite->addTest(new TestCaller(ChangePicturePathFilterTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {eXg
void ChangePicturePathFilterTest::testBasic(){
	Scene* scene = LampGraphics::createScene("test");
	PictureManager* manager = scene->getPictureManager();
	PictureRGB8* pic0 = manager->createPictureRGB8("pic0");
	pic0->setPath("abc.txt");
	PictureRGB8* pic1 = manager->createPictureRGB8("pic1");
	pic1->setPath("C:\\abc\\def.txt");
	PictureRGB8* pic2 = manager->createPictureRGB8("pic2");
	pic2->setPath("/abc/def.txt");
	PictureRGB8* pic3 = manager->createPictureRGB8("pic3");
	pic3->setPath("abc/");
	PictureRGB8* pic4 = manager->createPictureRGB8("pic4");
	pic4->setPath("");
	PictureRGB8* pic5 = manager->createPictureRGB8("pic5");
	pic5->setPath("/abc");

	// tB^
	SceneFilter sceneFilter(scene);
	sceneFilter.filter("ChangePicturePath hoge/");

	// `FbN
	TestEquals("hoge/abc.txt", pic0->getPath());
	TestEquals("hoge/def.txt", pic1->getPath());
	TestEquals("hoge/def.txt", pic2->getPath());
	TestEquals("hoge/", pic3->getPath());
	TestEquals("hoge/", pic4->getPath());
	TestEquals("hoge/abc", pic5->getPath());
	
	// n
	TestEquals(6, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
