//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Scene/SceneTest.h"
#include "Graphics/System/LampGraphics.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* SceneTest::suite(){
	TestSuite* suite = new TestSuite("SceneTest");
	suite->addTest(new TestCaller(SceneTest, testConstructor));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void SceneTest::testConstructor(){
	TestEquals(68, (int)sizeof(Scene));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	// e}l[W
	TestAssert(scene->getMaterialManager() != NULL);
	TestAssert(scene->getTextureManager() != NULL);
	TestAssert(scene->getPictureManager() != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
