//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * tÕeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Primitive/VisibilityTest.h"
#include "Graphics/Primitive/Visibility.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* VisibilityTest::suite(){
	TestSuite* suite = new TestSuite("VisibilityTest");
	suite->addTest(new TestCaller(VisibilityTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {eXg
void VisibilityTest::testBasic(){
	TestEquals(1, (int)sizeof(Visibility));
	Visibility visible;
	Visibility invisible(Visibility::invisible);
	Visibility understand = Visibility::understand;
	TestAssert(visible == Visibility::visible);
	TestAssert(visible != Visibility::invisible);
	TestAssert(visible != Visibility::understand);
	TestAssert(invisible != Visibility::visible);
	TestAssert(invisible == Visibility::invisible);
	TestAssert(invisible != Visibility::understand);
	TestAssert(understand != Visibility::visible);
	TestAssert(understand != Visibility::invisible);
	TestAssert(understand == Visibility::understand);
}
//------------------------------------------------------------------------------
