//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RGBA8rbgsN`̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Picture/PictureRGBA8Test.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Picture/PictureManager.h"
#include "Graphics/Texture/TextureManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* PictureRGBA8Test::suite(){
	TestSuite* suite = new TestSuite("PictureRGBA8Test");
	suite->addTest(new TestCaller(PictureRGBA8Test, testData));
	suite->addTest(new TestCaller(PictureRGBA8Test, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void PictureRGBA8Test::testData(){
//	TestEquals(48, (int)sizeof(PictureRGBA8));
	Scene* scene = LampGraphics::createScene("test");
	PictureManager* manager = scene->getPictureManager();
	PictureRGBA8* pic0 = manager->createPictureRGBA8("pic0");
	TestAssert(pic0->isPicture());
	TestAssert(pic0->isPictureRGBA8());
	// O
	TestEquals("pic0", pic0->getName());
	// pX
	TestEquals("", pic0->getPath());
	pic0->setPath("abc");
	TestEquals("abc", pic0->getPath());
	// TCY
	TestAssert(DimensionI(0, 0) == pic0->getSize());
	TestAssert(NULL == pic0->getImage());
	pic0->setSize(DimensionI(1, 1));
	TestAssert(DimensionI(1, 1) == pic0->getSize());
	TestAssert(NULL != pic0->getImage());
	Color4c color(255, 128, 64, 192);
	pic0->setImage(&color);
	TestAssert(color == *pic0->getImage());
	// n
	TestEquals(0, manager->destroy(pic0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void PictureRGBA8Test::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	PictureManager* manager = scene->getPictureManager();
	PictureRGBA8* pic0 = manager->createPictureRGBA8("pic0");
	pic0->setPath("abc");
	pic0->setSize(DimensionI(1, 1));
	Color4c color(255, 128, 64, 192);
	pic0->setImage(&color);

	PictureRGBA8* pic1 = pic0->copyPictureRGBA8();
	TestEquals("pic0_0", pic1->getName());
	TestEquals("abc", pic1->getPath());
	TestAssert(DimensionI(1, 1) == pic1->getSize());
	TestAssert(color == *pic1->getImage());

	// n
	TestEquals(2, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
