//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RGB8rbgsN`̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Picture/PictureRGB8Test.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Picture/PictureManager.h"
#include "Graphics/Texture/TextureManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* PictureRGB8Test::suite(){
	TestSuite* suite = new TestSuite("PictureRGB8Test");
	suite->addTest(new TestCaller(PictureRGB8Test, testData));
	suite->addTest(new TestCaller(PictureRGB8Test, testReference));
	suite->addTest(new TestCaller(PictureRGB8Test, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void PictureRGB8Test::testData(){
//	TestEquals(48, (int)sizeof(PictureRGB8));
	Scene* scene = LampGraphics::createScene("test");
	PictureManager* manager = scene->getPictureManager();
	PictureRGB8* pic0 = manager->createPictureRGB8("pic0");
	TestAssert(pic0->isPicture());
	TestAssert(pic0->isPictureRGB8());
	// O
	TestEquals("pic0", pic0->getName());
	// pX
	TestEquals("", pic0->getPath());
	pic0->setPath("abc");
	TestEquals("abc", pic0->getPath());
	// TCY
	TestAssert(DimensionI(0, 0) == pic0->getSize());
	TestAssert(NULL == pic0->getImage());
	pic0->setSize(DimensionI(1, 1));
	TestAssert(DimensionI(1, 1) == pic0->getSize());
	TestAssert(NULL != pic0->getImage());
	Color3c color(255, 128, 64);
	pic0->setImage(&color);
	TestAssert(color == *pic0->getImage());
	// n
	TestEquals(0, manager->destroy(pic0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void PictureRGB8Test::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	PictureManager* manager = scene->getPictureManager();
	PictureRGB8* pic0 = manager->createPictureRGB8("pic0");

	// ڂ̃eNX`֒ǉ
	TestEquals(0, pic0->getParentCount());
	TextureManager* textureManager = scene->getTextureManager();
	Texture* tex0 = textureManager->createSurfaceTexture("tex0");
	TestAssert(tex0->getPictureCount() == 0);
	tex0->addPicture(pic0);
	TestAssert(tex0->getPictureCount() == 1);
	TestAssert(tex0->getPicture(0) == pic0);
	TestEquals(1, pic0->getParentCount());
	// ڂ̃eNX`֒ǉ
	Texture* tex1 = textureManager->createSurfaceTexture("tex1");
	tex1->addPicture(pic0);
	TestEquals(2, pic0->getParentCount());
	TestAssert(pic0->getParent(0) == tex0);
	TestAssert(pic0->getParent(1) == tex1);
	TestEquals(2, manager->destroy(pic0));
	// ڂ̃eNX`폜
	tex0->removePicture(pic0);
	TestAssert(tex0->getPictureCount() == 0);
	TestEquals(1, pic0->getParentCount());
	TestEquals(1, manager->destroy(pic0));
	// ڂ̃eNX`폜
	tex1->removePicture(pic0);
	TestAssert(tex1->getPictureCount() == 0);
	TestEquals(0, pic0->getParentCount());
	textureManager->destroy(tex0);
	textureManager->destroy(tex1);

	// n
	TestEquals(0, manager->destroy(pic0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void PictureRGB8Test::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	PictureManager* manager = scene->getPictureManager();
	PictureRGB8* pic0 = manager->createPictureRGB8("pic0");
	pic0->setPath("abc");
	pic0->setSize(DimensionI(1, 1));
	Color3c color(255, 128, 64);
	pic0->setImage(&color);

	PictureRGB8* pic1 = pic0->copyPictureRGB8();
	TestEquals("pic0_0", pic1->getName());
	TestEquals("abc", pic1->getPath());
	TestAssert(DimensionI(1, 1) == pic1->getSize());
	TestAssert(color == *pic1->getImage());

	// n
	TestEquals(1, Picture::destroy(pic0));
	TestEquals(1, Picture::destroy(pic1));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
