//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * sN`}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Picture/PictureManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Picture/PictureManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* PictureManagerTest::suite(){
	TestSuite* suite = new TestSuite("PictureManagerTest");
	suite->addTest(new TestCaller(PictureManagerTest, testConstructor));
	suite->addTest(new TestCaller(PictureManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void PictureManagerTest::testConstructor(){
//	TestEquals(40, (int)sizeof(PictureManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	PictureManager* manager = scene->getPictureManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void PictureManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	PictureManager* manager = scene->getPictureManager();
	// f[^x[X̍\z
	int pictureCount = 257;
	String* names = new String[pictureCount];
	Picture** pictures = new Picture*[pictureCount];
	for(int i = 0; i < pictureCount; i++){
		names[i].format("picture%d", i);
	}
	for(int i = 0; i < pictureCount; i++){
		pictures[i] = manager->createPictureRGB8(names[i]);
	}
	// zANZX
	TestEquals(pictureCount, manager->getCount());
	for(int i = 0; i < pictureCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(pictures[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < pictureCount; i++){
		Picture* picture = manager->search(names[i]);
		TestAssert(picture == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(pictures[i]));
	}
	// NA
	TestEquals(pictureCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] pictures;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
