//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Wf̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Model/StandardModelTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/SceneNode/SceneNodeManager.h"
#include "Graphics/Model/ModelManager.h"
#include "Graphics/Mesh/MeshManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* StandardModelTest::suite(){
	TestSuite* suite = new TestSuite("StandardModelTest");
	suite->addTest(new TestCaller(StandardModelTest, testData));
	suite->addTest(new TestCaller(StandardModelTest, testReference));
	suite->addTest(new TestCaller(StandardModelTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void StandardModelTest::testData(){
//	TestEquals(44, (int)sizeof(StandardModel));
	Scene* scene = LampGraphics::createScene("test");
	ModelManager* manager = scene->getModelManager();
	StandardModel* model0 = manager->createStandardModel("model0");
	TestAssert(model0->isModel());
	TestAssert(model0->isStandardModel());
	TestAssert(model0->castStandardModel() != NULL);
	// O
	TestEquals("model0", model0->getName());
	// \tO
	TestAssert(model0->isEnabled());
	model0->setEnabled(false);
	TestAssert(!model0->isEnabled());

	// n
	manager->destroy(model0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void StandardModelTest::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	ModelManager* manager = scene->getModelManager();
	StandardModel* model0 = manager->createStandardModel("model0");

	// V[m[h֒ǉ
	TestAssert(model0->getParent() == NULL);
	SceneNodeManager* sceneNodeManager = scene->getSceneNodeManager();
	SceneNode* sceneNode0 = sceneNodeManager->createSceneNode("sceneNode0");
	TestAssert(sceneNode0->getSceneLeafCount() == 0);
	sceneNode0->addSceneLeaf(model0);
	TestAssert(sceneNode0->getSceneLeafCount() == 1);
	TestAssert(sceneNode0->getSceneLeaf(0) == model0);
	TestAssert(model0->getParent() == sceneNode0);
	TestEquals(1, manager->destroy(model0));
	// V[m[h폜
	sceneNode0->removeSceneLeaf(model0);
	TestAssert(sceneNode0->getSceneLeafCount() == 0);
	TestAssert(model0->getParent() == NULL);
	sceneNodeManager->destroy(sceneNode0);

	// n
	TestEquals(0, manager->destroy(model0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void StandardModelTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	ModelManager* manager = scene->getModelManager();
	StandardModel* model0 = manager->createStandardModel("model0");
	model0->setEnabled(false);
	MeshManager* meshManager = scene->getMeshManager();
	RigidMesh* mesh0 = meshManager->createRigidMesh("mesh0");
	model0->addMesh(mesh0);

	StandardModel* model1 = model0->copyStandardModel(0);
	TestEquals("model0_0", model1->getName());
	TestAssert(!model1->isEnabled());
	TestEquals(1, model1->getMeshCount());
	TestEquals("mesh0_0", model1->getMesh(0)->getName());

	// n
	TestEquals(2, SceneLeaf::recursiveDestroy(model0));
	TestEquals(2, Model::recursiveDestroy(model1));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
