//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * f}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Model/ModelManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Model/ModelManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* ModelManagerTest::suite(){
	TestSuite* suite = new TestSuite("ModelManagerTest");
	suite->addTest(new TestCaller(ModelManagerTest, testConstructor));
	suite->addTest(new TestCaller(ModelManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void ModelManagerTest::testConstructor(){
	TestEquals(40, (int)sizeof(ModelManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	ModelManager* manager = scene->getModelManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void ModelManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	ModelManager* manager = scene->getModelManager();
	// f[^x[X̍\z
	int modelCount = 257;
	String* names = new String[modelCount];
	Model** models = new Model*[modelCount];
	for(int i = 0; i < modelCount; i++){
		names[i].format("model%d", i);
	}
	for(int i = 0; i < modelCount; i++){
		models[i] = manager->createStandardModel(names[i]);
	}
	// zANZX
	TestEquals(modelCount, manager->getCount());
	for(int i = 0; i < modelCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(models[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < modelCount; i++){
		Model* model = manager->search(names[i]);
		TestAssert(model == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(models[i]));
	}
	// NA
	TestEquals(modelCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] models;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
