//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bVf[^̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/MeshData/MeshDataTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/MeshData/MeshDataManager.h"
#include "Graphics/Mesh/MeshManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* MeshDataTest::suite(){
	TestSuite* suite = new TestSuite("MeshDataTest");
	suite->addTest(new TestCaller(MeshDataTest, testData));
	suite->addTest(new TestCaller(MeshDataTest, testReference));
	suite->addTest(new TestCaller(MeshDataTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void MeshDataTest::testData(){
//	TestEquals(64, (int)sizeof(MeshData));
	Scene* scene = LampGraphics::createScene("test");
	MeshDataManager* manager = scene->getMeshDataManager();
	MeshData* meshData0 = manager->createMeshData("meshData0");
	TestAssert(meshData0->isMeshData());
	TestAssert(meshData0->isMeshData());
	TestAssert(meshData0->castMeshData() != NULL);
	// O
	TestEquals("meshData0", meshData0->getName());
	// oEfBO{bNX
	TestAssert(meshData0->getBoundingBox() ==
		AxisAlignedBox(0.f, 0.f, 0.f, 0.f, 0.f, 0.f));
	meshData0->setBoundingBox(AxisAlignedBox(-1.f, -1.f, -1.f, 1.f, 1.f, 1.f));
	TestAssert(meshData0->getBoundingBox() ==
		AxisAlignedBox(-1.f, -1.f, -1.f, 1.f, 1.f, 1.f));
	// oEfBOXtBA
	TestAssert(meshData0->getBoundingSphere() == Sphere(0.f, 0.f, 0.f, 0.f));
	meshData0->setBoundingSphere(Sphere(-1.f, -1.f, -1.f, 1.f));
	TestAssert(meshData0->getBoundingSphere() == Sphere(-1.f, -1.f, -1.f, 1.f));
	// v~eBu^Cv
	TestAssert(Mesh::triangleList == meshData0->getPrimitiveType());
	TestAssert(!meshData0->hasVertexIndices());
	meshData0->setPrimitiveType(Mesh::indexedTriangleList);
	TestAssert(Mesh::indexedTriangleList == meshData0->getPrimitiveType());
	TestAssert(meshData0->hasVertexIndices());
	// _CfbNX
	TestEquals(0, meshData0->getVertexIndexCount());
	meshData0->setVertexIndexCount(16);
	TestEquals(16, meshData0->getVertexIndexCount());
	for(int i = 0; i < 16; i++){
		meshData0->setVertexIndex(i, i);
		TestEquals(i, meshData0->getVertexIndex(i));
	}
	// _
	int vertexCount = 16;
	TestEquals(0, meshData0->getVertexCount());
	meshData0->setVertexCount(vertexCount);
	TestEquals(vertexCount, meshData0->getVertexCount());
	// ʒu
	for(int i = 0; i < vertexCount; i++){
		Vector3 pos((float)i, (float)i, (float)i);
		meshData0->setPosition(i, pos);
		TestAssert(pos == meshData0->getPosition(i));
	}
	// @
	TestAssert(!meshData0->hasNormal());
	meshData0->enableNormal(true);
	TestAssert(meshData0->hasNormal());
	for(int i = 0; i < vertexCount; i++){
		Vector3 nom((float)i, (float)i, (float)i);
		meshData0->setNormal(i, nom);
		TestAssert(nom == meshData0->getNormal(i));
	}
	// J[
	TestAssert(!meshData0->hasColor());
	meshData0->enableColor(true);
	TestAssert(meshData0->hasColor());
	for(int i = 0; i < vertexCount; i++){
		u_char value = (i & 0xff);
		Color4c col(value, value, value, value);
		meshData0->setColor(i, col);
		TestAssert(col == meshData0->getColor(i));
	}

	// n
	manager->destroy(meshData0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void MeshDataTest::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	MeshDataManager* manager = scene->getMeshDataManager();
	MeshData* meshData0 = manager->createMeshData("meshData0");

	// ڂ̃bV֒ǉ
	TestEquals(0, meshData0->getParentCount());
	MeshManager* meshManager = scene->getMeshManager();
	RigidMesh* mesh0 = meshManager->createRigidMesh("mesh0");
	TestAssert(mesh0->getMeshData() == NULL);
	mesh0->setMeshData(meshData0);
	TestAssert(mesh0->getMeshData() == meshData0);
	TestEquals(1, meshData0->getParentCount());
	// ڂ̃bV֒ǉ
	RigidMesh* mesh1 = meshManager->createRigidMesh("mesh1");
	mesh1->setMeshData(meshData0);
	TestEquals(2, meshData0->getParentCount());
	TestAssert(meshData0->getParent(0) == mesh0);
	TestAssert(meshData0->getParent(1) == mesh1);
	TestEquals(2, manager->destroy(meshData0));
	// ڂ̃bV폜
	mesh0->removeMeshData();
	TestAssert(mesh0->getMeshData() == NULL);
	TestEquals(1, meshData0->getParentCount());
	TestEquals(1, manager->destroy(meshData0));
	// ڂ̃bV폜
	mesh1->setMeshData(NULL);
	TestAssert(mesh1->getMeshData() == NULL);
	TestEquals(0, meshData0->getParentCount());
	meshManager->destroy(mesh0);
	meshManager->destroy(mesh1);

	// n
	TestEquals(0, manager->destroy(meshData0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void MeshDataTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	MeshDataManager* manager = scene->getMeshDataManager();
	MeshData* meshData0 = manager->createMeshData("meshData0");

	meshData0->setBoundingBox(AxisAlignedBox(-1.f, -1.f, -1.f, 1.f, 1.f, 1.f));
	meshData0->setBoundingSphere(Sphere(-1.f, -1.f, -1.f, 1.f));
	meshData0->setPrimitiveType(Mesh::indexedTriangleList);
	meshData0->setVertexIndexCount(16);
	for(int i = 0; i < 16; i++){
		meshData0->setVertexIndex(i, i);
	}
	int vertexCount = 16;
	meshData0->setVertexCount(vertexCount);
	for(int i = 0; i < vertexCount; i++){
		Vector3 pos((float)i, (float)i, (float)i);
		meshData0->setPosition(i, pos);
	}
	meshData0->enableNormal(true);
	for(int i = 0; i < vertexCount; i++){
		Vector3 nom((float)i, (float)i, (float)i);
		meshData0->setNormal(i, nom);
	}
	meshData0->enableColor(true);
	for(int i = 0; i < vertexCount; i++){
		u_char value = (i & 0xff);
		Color4c col(value, value, value, value);
		meshData0->setColor(i, col);
	}

	MeshData* meshData1 = meshData0->copy();
	TestEquals("meshData0_0", meshData1->getName());
	TestAssert(meshData1->getBoundingBox() ==
		AxisAlignedBox(-1.f, -1.f, -1.f, 1.f, 1.f, 1.f));
	TestAssert(meshData1->getBoundingSphere() == Sphere(-1.f, -1.f, -1.f, 1.f));
	TestAssert(Mesh::indexedTriangleList == meshData1->getPrimitiveType());
	TestAssert(meshData1->hasVertexIndices());
	TestEquals(16, meshData1->getVertexIndexCount());
	for(int i = 0; i < 16; i++){
		TestEquals(i, meshData1->getVertexIndex(i));
	}
	TestEquals(vertexCount, meshData1->getVertexCount());
	for(int i = 0; i < vertexCount; i++){
		Vector3 pos((float)i, (float)i, (float)i);
		TestAssert(pos == meshData1->getPosition(i));
	}
	TestAssert(meshData1->hasNormal());
	for(int i = 0; i < vertexCount; i++){
		Vector3 nom((float)i, (float)i, (float)i);
		TestAssert(nom == meshData1->getNormal(i));
	}
	TestAssert(meshData1->hasColor());
	for(int i = 0; i < vertexCount; i++){
		u_char value = (i & 0xff);
		Color4c col(value, value, value, value);
		TestAssert(col == meshData1->getColor(i));
	}

	// n
	TestEquals(1, MeshData::destroy(meshData0));
	TestEquals(1, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------

