//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bVf[^}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/MeshData/MeshDataManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/MeshData/MeshDataManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* MeshDataManagerTest::suite(){
	TestSuite* suite = new TestSuite("MeshDataManagerTest");
	suite->addTest(new TestCaller(MeshDataManagerTest, testConstructor));
	suite->addTest(new TestCaller(MeshDataManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void MeshDataManagerTest::testConstructor(){
//	TestEquals(40, (int)sizeof(MeshDataManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	MeshDataManager* manager = scene->getMeshDataManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void MeshDataManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	MeshDataManager* manager = scene->getMeshDataManager();
	// f[^x[X̍\z
	int meshDataCount = 257;
	String* names = new String[meshDataCount];
	MeshData** meshDatas = new MeshData*[meshDataCount];
	for(int i = 0; i < meshDataCount; i++){
		names[i].format("meshData%d", i);
	}
	for(int i = 0; i < meshDataCount; i++){
		meshDatas[i] = manager->createMeshData(names[i]);
	}
	// zANZX
	TestEquals(meshDataCount, manager->getCount());
	for(int i = 0; i < meshDataCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(meshDatas[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < meshDataCount; i++){
		MeshData* meshData = manager->search(names[i]);
		TestAssert(meshData == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(meshDatas[i]));
	}
	// NA
	TestEquals(meshDataCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] meshDatas;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
