//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̃bṼeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Mesh/RigidMeshTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Model/ModelManager.h"
#include "Graphics/Mesh/MeshManager.h"
#include "Graphics/MeshData/MeshDataManager.h"
#include "Graphics/Material/MaterialManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* RigidMeshTest::suite(){
	TestSuite* suite = new TestSuite("RigidMeshTest");
	suite->addTest(new TestCaller(RigidMeshTest, testData));
	suite->addTest(new TestCaller(RigidMeshTest, testReference));
	suite->addTest(new TestCaller(RigidMeshTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void RigidMeshTest::testData(){
//	TestEquals(40, (int)sizeof(RigidMesh));
	Scene* scene = LampGraphics::createScene("test");
	MeshManager* manager = scene->getMeshManager();
	MeshDataManager* meshDataManager = scene->getMeshDataManager();
	RigidMesh* mesh0 = manager->createRigidMesh("mesh0");
	MeshData* meshData0 = meshDataManager->createMeshData("mesh0d");
	mesh0->setMeshData(meshData0);
	TestAssert(mesh0->isMesh());
	TestAssert(mesh0->isRigidMesh());
	TestAssert(mesh0->castRigidMesh() != NULL);
	// O
	TestEquals("mesh0", mesh0->getName());
	// \tO
	TestAssert(mesh0->isEnabled());
	mesh0->setEnabled(false);
	TestAssert(!mesh0->isEnabled());
	// v~eBu^Cv
	TestAssert(Mesh::triangleList == mesh0->getPrimitiveType());
	TestAssert(!mesh0->hasVertexIndices());
	mesh0->setPrimitiveType(Mesh::indexedTriangleList);
	TestAssert(Mesh::indexedTriangleList == mesh0->getPrimitiveType());
	TestAssert(mesh0->hasVertexIndices());
	// _CfbNX
	TestEquals(0, mesh0->getVertexIndexCount());
	mesh0->setVertexIndexCount(16);
	TestEquals(16, mesh0->getVertexIndexCount());
	for(int i = 0; i < 16; i++){
		mesh0->setVertexIndex(i, i);
		TestEquals(i, mesh0->getVertexIndex(i));
	}
	// _
	int vertexCount = 16;
	TestEquals(0, mesh0->getVertexCount());
	mesh0->setVertexCount(vertexCount);
	TestEquals(16, mesh0->getVertexCount());
	// ʒu
	for(int i = 0; i < vertexCount; i++){
		Vector3 pos((float)i, (float)i, (float)i);
		mesh0->setPosition(i, pos);
		TestAssert(pos == mesh0->getPosition(i));
	}
	// @
	TestAssert(!mesh0->hasNormal());
	mesh0->enableNormal(true);
	TestAssert(mesh0->hasNormal());
	for(int i = 0; i < vertexCount; i++){
		Vector3 nom((float)i, (float)i, (float)i);
		mesh0->setNormal(i, nom);
		TestAssert(nom == mesh0->getNormal(i));
	}
	// J[
	TestAssert(!mesh0->hasColor());
	mesh0->enableColor(true);
	TestAssert(mesh0->hasColor());
	for(int i = 0; i < vertexCount; i++){
		u_char value = (i & 0xff);
		Color4c col(value, value, value, value);
		mesh0->setColor(i, col);
		TestAssert(col == mesh0->getColor(i));
	}
	// n
	mesh0->removeMeshData();
	meshDataManager->destroy(meshData0);
	manager->destroy(mesh0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void RigidMeshTest::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	MeshManager* manager = scene->getMeshManager();
	RigidMesh* mesh0 = manager->createRigidMesh("mesh0");

	// f֒ǉ
	TestAssert(mesh0->getParent() == NULL);
	ModelManager* modelManager = scene->getModelManager();
	StandardModel* model0 = modelManager->createStandardModel("model0");
	TestAssert(model0->getMeshCount() == 0);
	model0->addMesh(mesh0);
	TestAssert(model0->getMeshCount() == 1);
	TestAssert(model0->getMesh(0) == mesh0);
	TestAssert(mesh0->getParent() == model0);
	TestEquals(1, manager->destroy(mesh0));
	// f폜
	model0->removeMesh(mesh0);
	TestAssert(model0->getMeshCount() == 0);
	TestAssert(mesh0->getParent() == NULL);
	modelManager->destroy(model0);


	// n
	TestEquals(0, manager->destroy(mesh0));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void RigidMeshTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	MeshManager* manager = scene->getMeshManager();
	Mesh* mesh0 = manager->createRigidMesh("mesh0");
	MeshDataManager* meshDataManager = scene->getMeshDataManager();
	MeshData* meshData0 = meshDataManager->createMeshData("meshData0");
	mesh0->setMeshData(meshData0);
	MaterialManager* materialManager = scene->getMaterialManager();
	Material* material0 = materialManager->createBasicMaterial("material0");
	mesh0->setMaterial(material0);
	// Rs[
	Mesh* mesh1 = mesh0->copy(0);
	TestEquals("mesh0_0", mesh1->getName());
	TestAssert(mesh1->getMeshData() == meshData0);
	TestEquals("material0", mesh1->getMaterial()->getName());
	// n
	TestEquals(1, Mesh::recursiveDestroy(mesh0));
	TestEquals(3, Mesh::recursiveDestroy(mesh1));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
