//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bV}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Mesh/MeshManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Mesh/MeshManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* MeshManagerTest::suite(){
	TestSuite* suite = new TestSuite("MeshManagerTest");
	suite->addTest(new TestCaller(MeshManagerTest, testConstructor));
	suite->addTest(new TestCaller(MeshManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void MeshManagerTest::testConstructor(){
	TestEquals(40, (int)sizeof(MeshManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	MeshManager* manager = scene->getMeshManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void MeshManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	MeshManager* manager = scene->getMeshManager();
	// f[^x[X̍\z
	int meshCount = 257;
	String* names = new String[meshCount];
	Mesh** meshs = new Mesh*[meshCount];
	for(int i = 0; i < meshCount; i++){
		names[i].format("mesh%d", i);
	}
	for(int i = 0; i < meshCount; i++){
		meshs[i] = manager->createRigidMesh(names[i]);
	}
	// zANZX
	TestEquals(meshCount, manager->getCount());
	for(int i = 0; i < meshCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(meshs[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < meshCount; i++){
		Mesh* mesh = manager->search(names[i]);
		TestAssert(mesh == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(meshs[i]));
	}
	// NA
	TestEquals(meshCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] meshs;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
