//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }eÃeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Material/MaterialTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Material/MaterialManager.h"
#include "Graphics/Mesh/MeshManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* MaterialTest::suite(){
	TestSuite* suite = new TestSuite("MaterialTest");
	suite->addTest(new TestCaller(MaterialTest, testData));
	suite->addTest(new TestCaller(MaterialTest, testReference));
	suite->addTest(new TestCaller(MaterialTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void MaterialTest::testData(){
	//	TestEquals(84, (int)sizeof(Material));
	Scene* scene = LampGraphics::createScene("test");
	MaterialManager* manager = scene->getMaterialManager();
	Material* material0 = manager->createBasicMaterial("material0");
	TestAssert(material0->isMaterial());
	// O
	TestEquals("material0", material0->getName());
	// Dx
	TestEquals(0, material0->getPriority());
	material0->setPriority(1234);
	TestEquals(1234, material0->getPriority());
	// uhXe[g
	for(int i = 0; i < Material::blendStateMax; i++){
		TestEquals(i, (int)Material::blendStateFromString(
			Material::blendStateToString((Material::BlendState)i)));
	}
	// uh\[X
	TestEquals(Material::blendStateSourceAlpha, material0->getBlendSource());
	material0->setBlendSource(Material::blendStateOne);
	TestEquals(Material::blendStateOne, material0->getBlendSource());
	// uhfXeBl[V
	TestEquals(Material::blendStateInverseSourceAlpha, material0->getBlendDestination());
	material0->setBlendDestination(Material::blendStateOne);
	TestEquals(Material::blendStateOne, material0->getBlendDestination());
	// ufBO
	TestAssert(material0->getBlendMode() == Material::blendModeDisable);
	material0->setBlendMode(Material::blendModeAdd);
	TestAssert(material0->getBlendMode() == Material::blendModeAdd);
	// At@l
	TestEquals(1.f, material0->getAlpha());
	material0->setAlpha(12.34f);
	TestEquals(12.34f, material0->getAlpha());
	// Z
	TestAssert(material0->useZWrite());
	material0->setZWrite(false);
	TestAssert(!material0->useZWrite());
	// ZeXg
	TestAssert(material0->useZTest());
	material0->setZTest(false);
	TestAssert(!material0->useZTest());
	// tHOIvV
	for(int i = 0; i < Material::fogOptionMax; i++){
		TestEquals(i, (int)Material::fogOptionFromString(
			Material::fogOptionToString((Material::FogOption)i)));
	}
	TestEquals(Material::fogOptionNone, material0->getFogOption());
	material0->setFogOption(Material::fogOptionBlack);
	TestEquals(Material::fogOptionBlack, material0->getFogOption());
	// n
	manager->destroy(material0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// QƃeXg
void MaterialTest::testReference(){
	Scene* scene = LampGraphics::createScene("test");
	MaterialManager* manager = scene->getMaterialManager();
	Material* material0 = manager->createBasicMaterial("material0");

	// ڂ̃bV֒ǉ
	TestEquals(0, material0->getParentCount());
	MeshManager* meshManager = scene->getMeshManager();
	RigidMesh* mesh0 = meshManager->createRigidMesh("mesh0");
	TestAssert(mesh0->getMaterial() == NULL);
	mesh0->setMaterial(material0);
	TestAssert(mesh0->getMaterial() == material0);
	TestEquals(1, material0->getParentCount());
	// ڂ̃bV֒ǉ
	RigidMesh* mesh1 = meshManager->createRigidMesh("mesh1");
	mesh1->setMaterial(material0);
	TestEquals(2, material0->getParentCount());
	TestAssert(material0->getParent(0) == mesh0);
	TestAssert(material0->getParent(1) == mesh1);
	TestEquals(2, manager->destroy(material0));
	// ڂ̃bV폜
	mesh0->removeMaterial();
	TestAssert(mesh0->getMaterial() == NULL);
	TestEquals(1, material0->getParentCount());
	TestEquals(1, manager->destroy(material0));
	// ڂ̃bV폜
	mesh1->setMaterial(NULL);
	TestAssert(mesh1->getMaterial() == NULL);
	TestEquals(0, material0->getParentCount());
	meshManager->destroy(mesh0);
	meshManager->destroy(mesh1);

	// n
	manager->destroy(material0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void MaterialTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	MaterialManager* manager = scene->getMaterialManager();
	BasicMaterial* material0 = manager->createBasicMaterial("material0");
	material0->setPriority(1234);
	material0->setBlendMode(Material::blendModeAdd);
	material0->setBlendSource(Material::blendStateOne);
	material0->setBlendDestination(Material::blendStateOne);
	material0->setAlpha(12.34f);
	material0->setZWrite(false);
	material0->setZTest(false);
	material0->setFogOption(Material::fogOptionBlack);

	Material* material1 = material0->copy(0);
	TestEquals(1234, material1->getPriority());
	TestAssert(material1->getBlendMode() == Material::blendModeAdd);
	TestEquals(Material::blendStateOne, material1->getBlendSource());
	TestEquals(Material::blendStateOne, material1->getBlendDestination());
	TestEquals(12.34f, material1->getAlpha());
	TestAssert(!material1->useZWrite());
	TestAssert(!material1->useZWrite());
	TestEquals(Material::fogOptionBlack, material1->getFogOption());

	// n
	TestEquals(2, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
