//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }eA}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Material/MaterialManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Material/MaterialManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* MaterialManagerTest::suite(){
	TestSuite* suite = new TestSuite("MaterialManagerTest");
	suite->addTest(new TestCaller(MaterialManagerTest, testConstructor));
	suite->addTest(new TestCaller(MaterialManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void MaterialManagerTest::testConstructor(){
	TestEquals(44, (int)sizeof(MaterialManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	MaterialManager* manager = scene->getMaterialManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void MaterialManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	MaterialManager* manager = scene->getMaterialManager();
	// f[^x[X̍\z
	int materialCount = 257;
	String* names = new String[materialCount];
	Material** materials = new Material*[materialCount];
	for(int i = 0; i < materialCount; i++){
		names[i].format("material%d", i);
	}
	for(int i = 0; i < materialCount; i++){
		materials[i] = manager->createBasicMaterial(names[i]);
	}
	// zANZX
	TestEquals(materialCount, manager->getCount());
	for(int i = 0; i < materialCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(materials[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < materialCount; i++){
		Material* material = manager->search(names[i]);
		TestAssert(material == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(materials[i]));
	}
	// NA
	TestEquals(materialCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] materials;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
