//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {}eÃeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Material/BasicMaterialTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Material/MaterialManager.h"
#include "Graphics/Texture/TextureManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* BasicMaterialTest::suite(){
	TestSuite* suite = new TestSuite("BasicMaterialTest");
	suite->addTest(new TestCaller(BasicMaterialTest, testData));
	suite->addTest(new TestCaller(BasicMaterialTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void BasicMaterialTest::testData(){
	Scene* scene = LampGraphics::createScene("test");
	MaterialManager* manager = scene->getMaterialManager();
	BasicMaterial* material0 = manager->createBasicMaterial("material0");
	TestAssert(material0->isMaterial());
	TestAssert(material0->isBasicMaterial());
	TestAssert(material0->castBasicMaterial() != NULL);
	// fBt[YJ[
	TestAssert(Color3f(1.f, 1.f, 1.f) == material0->getDiffuseColor());
	material0->setDiffuseColor(Color3f(0.1f, 0.2f, 0.3f));
	TestAssert(Color3f(0.1f, 0.2f, 0.3f) == material0->getDiffuseColor());
	// XyLJ[
	TestAssert(!material0->isSpecularEnabled());
	TestAssert(Color3f(0.f, 0.f, 0.f) == material0->getSpecularColor());
	material0->setSpecularColor(Color3f(0.1f, 0.2f, 0.3f));
	TestAssert(Color3f(0.1f, 0.2f, 0.3f) == material0->getSpecularColor());
	// XyLp[
	TestAssert(material0->isSpecularEnabled());
	TestEquals(0.f, material0->getSpecularPower());
	material0->setSpecularPower(12.34f);
	TestEquals(12.34f, material0->getSpecularPower());
	TestAssert(material0->isSpecularEnabled());
	// ArGgJ[
	TestAssert(Color3f(1.f, 1.f, 1.f) == material0->getAmbientColor());
	material0->setAmbientColor(Color3f(0.2f, 0.3f, 0.4f));
	TestAssert(Color3f(0.2f, 0.3f, 0.4f) == material0->getAmbientColor());
	// G~bVuJ[
	TestAssert(Color3f(0.f, 0.f, 0.f) == material0->getEmissiveColor());
	material0->setEmissiveColor(Color3f(0.3f, 0.4f, 0.5f));
	TestAssert(Color3f(0.3f, 0.4f, 0.5f) == material0->getEmissiveColor());
	// n
	manager->destroy(material0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void BasicMaterialTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	MaterialManager* manager = scene->getMaterialManager();
	BasicMaterial* material0 = manager->createBasicMaterial("material0");
	material0->setDiffuseColor(Color3f(0.1f, 0.2f, 0.3f));
	material0->setSpecularColor(Color3f(0.1f, 0.2f, 0.3f));
	material0->setSpecularPower(12.34f);
	material0->setAmbientColor(Color3f(0.2f, 0.3f, 0.4f));
	material0->setEmissiveColor(Color3f(0.3f, 0.4f, 0.5f));
	TextureManager* textureManager = scene->getTextureManager();
	Texture* texture = textureManager->createSurfaceTexture("tex0");
	material0->setBaseTexture(texture);
	material0->setGlossTexture(texture);
	material0->setLightTexture(texture);
	material0->setStainTexture(texture);

	BasicMaterial* material1 = material0->copyBasicMaterial(0);
	TestAssert(Color3f(0.1f, 0.2f, 0.3f) == material1->getDiffuseColor());
	TestAssert(Color3f(0.1f, 0.2f, 0.3f) == material1->getSpecularColor());
	TestEquals(12.34f, material1->getSpecularPower());
	TestAssert(Color3f(0.2f, 0.3f, 0.4f) == material1->getAmbientColor());
	TestAssert(Color3f(0.3f, 0.4f, 0.5f) == material1->getEmissiveColor());
	TestEquals("tex0", material1->getBaseTexture()->getName());
	TestEquals("tex0", material1->getGlossTexture()->getName());
	TestEquals("tex0", material1->getLightTexture()->getName());
	TestEquals("tex0", material1->getStainTexture()->getName());

	// n
	TestEquals(1, Material::recursiveDestroy(material0));
	TestEquals(2, Material::recursiveDestroy(material1));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
