//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * |CgCg̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Light/PointLightTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Light/LightManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* PointLightTest::suite(){
	TestSuite* suite = new TestSuite("PointLightTest");
	suite->addTest(new TestCaller(PointLightTest, testData));
	suite->addTest(new TestCaller(PointLightTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void PointLightTest::testData(){
	Scene* scene = LampGraphics::createScene("test");
	LightManager* manager = scene->getLightManager();
	PointLight* light0 = manager->createPointLight("light0");
	TestAssert(light0->isLight());
	TestAssert(light0->isPointLight());
	TestAssert(light0->castPointLight() != NULL);
	// O
	TestEquals("light0", light0->getName());
	// LAtO
	TestAssert(light0->isEnabled());
	light0->setEnabled(false);
	TestAssert(!light0->isEnabled());
	// CgJ[
	TestAssert(light0->getColor() == Color3f(1.f, 1.f, 1.f));
	light0->setColor(Color3f(1.f, 2.f, 3.f));
	TestAssert(light0->getColor() == Color3f(1.f, 2.f, 3.f));
	// fBt[YJ[
	light0->setDiffuseColor(Color3f(4.f, 3.f, 2.f));
	TestAssert(light0->getDiffuseColor() == Color3f(4.f, 3.f, 2.f));
	// XyLJ[
	light0->setSpecularColor(Color3f(8.f, 7.f, 6.f));
	TestAssert(light0->getSpecularColor() == Color3f(8.f, 7.f, 6.f));
	// ʒu
	TestAssert(light0->getPosition() == Vector3(0.f, 0.f, 0.f));
	light0->setPosition(Vector3(1.f, 2.f, 3.f));
	TestAssert(light0->getPosition() == Vector3(1.f, 2.f, 3.f));
	// W
	TestEquals(1.84467435e+019f, light0->getRange());
	light0->setRange(1.f);
	TestEquals(1.f, light0->getRange());
	// W
	TestEquals(1.f, light0->getAttenuation0());
	TestEquals(0.f, light0->getAttenuation1());
	TestEquals(0.f, light0->getAttenuation2());
	light0->setAttenuation(0.f, 1.f, 2.f);
	TestEquals(0.f, light0->getAttenuation0());
	TestEquals(1.f, light0->getAttenuation1());
	TestEquals(2.f, light0->getAttenuation2());

	// n
	manager->destroy(light0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void PointLightTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	LightManager* manager = scene->getLightManager();
	PointLight* light0 = manager->createPointLight("light0");
	light0->setEnabled(false);
	light0->setDiffuseColor(Color3f(4.f, 3.f, 2.f));
	light0->setSpecularColor(Color3f(8.f, 7.f, 6.f));
	light0->setPosition(Vector3(1.f, 2.f, 3.f));
	light0->setRange(1.f);
	light0->setAttenuation(0.f, 1.f, 2.f);

	PointLight* light1 = light0->copyPointLight();
	TestAssert(!light1->isEnabled());
	TestAssert(light1->getDiffuseColor() == Color3f(4.f, 3.f, 2.f));
	TestAssert(light1->getSpecularColor() == Color3f(8.f, 7.f, 6.f));
	TestAssert(light1->getPosition() == Vector3(1.f, 2.f, 3.f));
	TestEquals(1.f, light1->getRange());
	TestEquals(0.f, light1->getAttenuation0());
	TestEquals(1.f, light1->getAttenuation1());
	TestEquals(2.f, light1->getAttenuation2());

	// n
	TestEquals(2, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
