//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Cg}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Light/LightManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Light/LightManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* LightManagerTest::suite(){
	TestSuite* suite = new TestSuite("LightManagerTest");
	suite->addTest(new TestCaller(LightManagerTest, testConstructor));
	suite->addTest(new TestCaller(LightManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void LightManagerTest::testConstructor(){
	TestEquals(40, (int)sizeof(LightManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	LightManager* manager = scene->getLightManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void LightManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	LightManager* manager = scene->getLightManager();
	// f[^x[X̍\z
	int lightCount = 257;
	String* names = new String[lightCount];
	Light** lights = new Light*[lightCount];
	for(int i = 0; i < lightCount; i++){
		names[i].format("light%d", i);
	}
	for(int i = 0; i < lightCount; i++){
		lights[i] = manager->createAmbientLight(names[i]);
	}
	// zANZX
	TestEquals(lightCount, manager->getCount());
	for(int i = 0; i < lightCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(lights[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < lightCount; i++){
		Light* light = manager->search(names[i]);
		TestAssert(light == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(lights[i]));
	}
	// NA
	TestEquals(lightCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] lights;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
