//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fBNViCg̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Light/DirectionalLightTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Light/LightManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* DirectionalLightTest::suite(){
	TestSuite* suite = new TestSuite("DirectionalLightTest");
	suite->addTest(new TestCaller(DirectionalLightTest, testData));
	suite->addTest(new TestCaller(DirectionalLightTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void DirectionalLightTest::testData(){
	Scene* scene = LampGraphics::createScene("test");
	LightManager* manager = scene->getLightManager();
	DirectionalLight* light0 = manager->createDirectionalLight("light0");
	TestAssert(light0->isLight());
	TestAssert(light0->isDirectionalLight());
	TestAssert(light0->castDirectionalLight() != NULL);
	// O
	TestEquals("light0", light0->getName());
	// LAtO
	TestAssert(light0->isEnabled());
	light0->setEnabled(false);
	TestAssert(!light0->isEnabled());
	// CgJ[
	TestAssert(light0->getColor() == Color3f(1.f, 1.f, 1.f));
	light0->setColor(Color3f(1.f, 2.f, 3.f));
	TestAssert(light0->getColor() == Color3f(1.f, 2.f, 3.f));
	// fBt[YJ[
	light0->setDiffuseColor(Color3f(4.f, 3.f, 2.f));
	TestAssert(light0->getDiffuseColor() == Color3f(4.f, 3.f, 2.f));
	// XyLJ[
	light0->setSpecularColor(Color3f(8.f, 7.f, 6.f));
	TestAssert(light0->getSpecularColor() == Color3f(8.f, 7.f, 6.f));
	// 
	TestAssert(light0->getDirection() == Vector3(0.f, -1.f, 0.f));
	light0->setDirection(Vector3(1.f, 2.f, 3.f));
	TestAssert(light0->getDirection() == Vector3(1.f, 2.f, 3.f).normalize());

	// n
	manager->destroy(light0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void DirectionalLightTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	LightManager* manager = scene->getLightManager();
	DirectionalLight* light0 = manager->createDirectionalLight("light0");
	light0->setEnabled(false);
	light0->setDiffuseColor(Color3f(4.f, 3.f, 2.f));
	light0->setSpecularColor(Color3f(8.f, 7.f, 6.f));
	light0->setDirection(Vector3(1.f, 2.f, 3.f));

	DirectionalLight* light1 = light0->copyDirectionalLight();
	TestAssert(!light1->isEnabled());
	TestAssert(light1->getDiffuseColor() == Color3f(4.f, 3.f, 2.f));
	TestAssert(light1->getSpecularColor() == Color3f(8.f, 7.f, 6.f));
	TestAssert(light1->getDirection().epsilonEquals(
		Vector3(1.f, 2.f, 3.f).normalize(), Math::epsilon));

	// n
	TestEquals(2, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
