//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ArGgCg̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Light/AmbientLightTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Light/LightManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* AmbientLightTest::suite(){
	TestSuite* suite = new TestSuite("AmbientLightTest");
	suite->addTest(new TestCaller(AmbientLightTest, testData));
	suite->addTest(new TestCaller(AmbientLightTest, testCopy));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void AmbientLightTest::testData(){
	Scene* scene = LampGraphics::createScene("test");
	LightManager* manager = scene->getLightManager();
	AmbientLight* light0 = manager->createAmbientLight("light0");
	TestAssert(light0->isLight());
	TestAssert(light0->isAmbientLight());
	TestAssert(light0->castAmbientLight() != NULL);
	// O
	TestEquals("light0", light0->getName());
	// LAtO
	TestAssert(light0->isEnabled());
	light0->setEnabled(false);
	TestAssert(!light0->isEnabled());
	// CgJ[
	TestAssert(light0->getColor() == Color3f(0.1f, 0.1f, 0.1f));
	light0->setColor(Color3f(1.f, 2.f, 3.f));
	TestAssert(light0->getColor() == Color3f(1.f, 2.f, 3.f));

	// n
	manager->destroy(light0);
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// Rs[eXg
void AmbientLightTest::testCopy(){
	Scene* scene = LampGraphics::createScene("test");
	LightManager* manager = scene->getLightManager();
	AmbientLight* light0 = manager->createAmbientLight("light0");
	light0->setEnabled(false);
	light0->setColor(Color3f(1.f, 2.f, 3.f));

	AmbientLight* light1 = light0->copyAmbientLight();
	TestAssert(!light1->isEnabled());
	TestAssert(light1->getColor() == Color3f(1.f, 2.f, 3.f));

	// n
	TestEquals(1, SceneLeaf::recursiveDestroy(light0));
	TestEquals(1, Light::destroy(light1));
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
