//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgV[o͂̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/InputOutput/TextSceneIOTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/InputOutput/TextSceneLoader.h"
#include "Graphics/InputOutput/TextSceneSaver.h"
#include "Core/InputOutput/TextFileReader.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TextSceneIOTest::suite(){
	TestSuite* suite = new TestSuite("TextSceneIOTest");
	suite->addTest(new TestCaller(TextSceneIOTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {eXg
void TextSceneIOTest::testBasic(){
// V[ďoAǂݍōēxoŔr
// ďo͂̕KvȂȂ邵AoCiAeLXgΉȒPɂȂ
	String loadPath(
		"Resource/Graphics/InputOutput/TextSceneIOTest_testBasic.tsn");
	String savePath(
		"Resource/Temporary/TextSceneIOTest_testBasic.tsn");
	Scene* scene = LampGraphics::createScene("test");
	// V[̃[h
	TextSceneLoader* loader = new TextSceneLoader();
	loader->load(loadPath, scene);
	delete loader;
	// V[̃Z[u
	TextSceneSaver* saver = new TextSceneSaver();
	saver->save(savePath, scene);
	delete saver;
	scene->clear();
	LampGraphics::destroyScene(scene);
	// t@C̓ꐫ`FbN
	TextFileReader* loadFile = new TextFileReader(loadPath);
	TextFileReader* saveFile = new TextFileReader(savePath);
	while(true){
		if(loadFile->isEnd()){ break; }
		TestAssert(!saveFile->isEnd());
		if(saveFile->isEnd()){ break; }
		String loadLine = loadFile->readLine();
		String saveLine = saveFile->readLine();
		TestEquals(loadLine, saveLine);
	}
	TestAssert(saveFile->isEnd());
	delete loadFile;
	delete saveFile;
}
//------------------------------------------------------------------------------
