//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * SẴOtBbNXeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/GraphicsAllTests.h"

#include "Graphics/Primitive/GraphicsPrimitiveAllTests.h"
#include "Graphics/Shader/GraphicsShaderAllTests.h"
#include "Graphics/Scene/GraphicsSceneAllTests.h"
#include "Graphics/Fog/GraphicsFogAllTests.h"
#include "Graphics/SceneNode/GraphicsSceneNodeAllTests.h"
#include "Graphics/Camera/GraphicsCameraAllTests.h"
#include "Graphics/Light/GraphicsLightAllTests.h"
#include "Graphics/Model/GraphicsModelAllTests.h"
#include "Graphics/Mesh/GraphicsMeshAllTests.h"
#include "Graphics/MeshData/GraphicsMeshDataAllTests.h"
#include "Graphics/Material/GraphicsMaterialAllTests.h"
#include "Graphics/Texture/GraphicsTextureAllTests.h"
#include "Graphics/Picture/GraphicsPictureAllTests.h"
#include "Graphics/InputOutput/GraphicsInputOutputAllTests.h"
#include "Graphics/SceneFilter/GraphicsSceneFilterAllTests.h"

//------------------------------------------------------------------------------
// RXgN^
GraphicsAllTests::GraphicsAllTests() : TestSuite("GraphicsAllTests"){
	// v~eBueXg
	addTest(new GraphicsPrimitiveAllTests());
	// VF[_eXg
//	addTest(new GraphicsShaderAllTests());
	// V[eXg
	addTest(new GraphicsSceneAllTests());
	// tHOeXg
	addTest(new GraphicsFogAllTests());
	// V[m[heXg
	addTest(new GraphicsSceneNodeAllTests());
	// JeXg
	addTest(new GraphicsCameraAllTests());
	// CgeXg
	addTest(new GraphicsLightAllTests());
	// feXg
	addTest(new GraphicsModelAllTests());
	// bVeXg
	addTest(new GraphicsMeshAllTests());
	// bVf[^eXg
	addTest(new GraphicsMeshDataAllTests());
	// }eAeXg
	addTest(new GraphicsMaterialAllTests());
	// eNX`eXg
	addTest(new GraphicsTextureAllTests());
	// sN`eXg
	addTest(new GraphicsPictureAllTests());
	// o̓eXg
	addTest(new GraphicsInputOutputAllTests());
	// V[tB^eXg
	addTest(new GraphicsSceneFilterAllTests());
}
//------------------------------------------------------------------------------
