//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * tHÕeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Fog/FogTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Fog/Fog.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* FogTest::suite(){
	TestSuite* suite = new TestSuite("FogTest");
	suite->addTest(new TestCaller(FogTest, testData));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void FogTest::testData(){
//	TestEquals(96, (int)sizeof(Fog));
	Scene* scene = LampGraphics::createScene("test");
	Fog* fog0 = scene->getFog();
	// LAtO
	TestAssert(!fog0->isEnabled());
	fog0->setEnabled(true);
	TestAssert(fog0->isEnabled());
	// J[
	TestAssert(fog0->getColor() == Color4c(128, 128, 128, 0));
	fog0->setColor(Color4c(1, 2, 3, 0));
	TestAssert(fog0->getColor() == Color4c(1, 2, 3, 0));
	// [h
	TestAssert(fog0->getMode() == Fog::modeLinear);
	fog0->setMode(Fog::modeExponent);
	TestAssert(fog0->getMode() == Fog::modeExponent);
	// Zx
	TestEquals(0.5f, fog0->getDensity());
	fog0->setDensity(1.f);
	TestEquals(1.f, fog0->getDensity());
	// jA
	TestEquals(1.f, fog0->getNear());
	fog0->setNear(10.f);
	TestEquals(10.f, fog0->getNear());
	// t@[
	TestEquals(10000.f, fog0->getFar());
	fog0->setFar(1.f);
	TestEquals(1.f, fog0->getFar());

	// n
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
