//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * J}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Graphics/Camera/CameraManagerTest.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Camera/CameraManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* CameraManagerTest::suite(){
	TestSuite* suite = new TestSuite("CameraManagerTest");
	suite->addTest(new TestCaller(CameraManagerTest, testConstructor));
	suite->addTest(new TestCaller(CameraManagerTest, testDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void CameraManagerTest::testConstructor(){
	TestEquals(40, (int)sizeof(CameraManager));
	Scene* scene = LampGraphics::createScene("test");
	TestAssert(scene != NULL);
	CameraManager* manager = scene->getCameraManager();
	TestAssert(manager != NULL);
	// NA
	TestEquals(0, scene->clear());
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void CameraManagerTest::testDatabase(){
	Scene* scene = LampGraphics::createScene("test");
	CameraManager* manager = scene->getCameraManager();
	// f[^x[X̍\z
	int cameraCount = 257;
	String* names = new String[cameraCount];
	Camera** cameras = new Camera*[cameraCount];
	for(int i = 0; i < cameraCount; i++){
		names[i].format("camera%d", i);
	}
	for(int i = 0; i < cameraCount; i++){
		cameras[i] = manager->createCamera(names[i]);
	}
	// zANZX
	TestEquals(cameraCount, manager->getCount());
	for(int i = 0; i < cameraCount; i++){
		TestEquals(names[i], manager->get(i)->getName());
		TestAssert(cameras[i] == manager->get(i));
	}
	// ANZX
	for(int i = 0; i < cameraCount; i++){
		Camera* camera = manager->search(names[i]);
		TestAssert(camera == manager->get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		TestEquals(0, manager->destroy(cameras[i]));
	}
	// NA
	TestEquals(cameraCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] cameras;
	delete[] names;
	LampGraphics::destroyScene(scene);
}
//------------------------------------------------------------------------------
