//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OpeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Primitive/TriangleTest.h"
#include "Geometry/Primitive/Triangle.h"

//------------------------------------------------------------------------------
// RXgN^
TriangleTest::TriangleTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TriangleTest::suite(){
	TestSuite* suite = new TestSuite("TriangleTest");
	suite->addTest(new TestCaller(TriangleTest, testConstructor));
	suite->addTest(new TestCaller(TriangleTest, testFixedNumber));
	suite->addTest(new TestCaller(TriangleTest, testSetValue));
	suite->addTest(new TestCaller(TriangleTest, testGetValue));
	suite->addTest(new TestCaller(TriangleTest, testTriangleArithmetic));
	suite->addTest(new TestCaller(TriangleTest, testTransform));
	suite->addTest(new TestCaller(TriangleTest, testLogicalOperation));
	suite->addTest(new TestCaller(TriangleTest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void TriangleTest::testConstructor(){
	TestEquals(36, (int)sizeof(Triangle));
	Triangle triangle0(Vector3(-1.f, -2.f, -3.f), Vector3(1.f, 2.f, 3.f),
		Vector3(3.f, 2.f, 1.f));
	Triangle triangle1(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f, 3.f, 2.f, 1.f);
	TestAssert(triangle0 == triangle1);
	Vector3 array[] = { Vector3(-1.f, -2.f, -3.f), Vector3(1.f, 2.f, 3.f),
		Vector3(3.f, 2.f, 1.f) };
	Triangle triangle2(array);
	TestAssert(triangle0 == triangle2);
}
//------------------------------------------------------------------------------
// 萔eXg
void TriangleTest::testFixedNumber(){
	Triangle triangle0(Vector3::zero, Vector3::zero, Vector3::zero);
	TestAssert(triangle0 == Triangle::zero);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void TriangleTest::testSetValue(){
	Triangle triangle0(Vector3(-1.f, -2.f, -3.f), Vector3(1.f, 2.f, 3.f),
		Vector3(3.f, 2.f, 1.f));
	Triangle triangle1;
	triangle1.set(Vector3(-1.f, -2.f, -3.f), Vector3(1.f, 2.f, 3.f),
		Vector3(3.f, 2.f, 1.f));
	TestAssert(triangle0 == triangle1);
	triangle1.set(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f, 3.f, 2.f, 1.f);
	TestAssert(triangle0 == triangle1);
	Vector3 array[] = { Vector3(-1.f, -2.f, -3.f), Vector3(1.f, 2.f, 3.f),
		Vector3(3.f, 2.f, 1.f) };
	triangle1.set(array);
	TestAssert(triangle0 == triangle1);
}
//------------------------------------------------------------------------------
// l̎擾eXg
void TriangleTest::testGetValue(){
	Triangle triangle0(Vector3(0.f, 0.f, 0.f), Vector3(0.f, 0.f, 1.f),
		Vector3(1.f, 0.f, 0.f));
	TestAssert(triangle0.getVertex(0) == Vector3(0.f, 0.f, 0.f));
	TestAssert(triangle0.getVertex(1) == Vector3(0.f, 0.f, 1.f));
	TestAssert(triangle0.getVertex(2) == Vector3(1.f, 0.f, 0.f));
	TestAssert(triangle0.getNormal() == Vector3(0.f, 1.f, 0.f));
}
//------------------------------------------------------------------------------
// OpZ
void TriangleTest::testTriangleArithmetic(){
	TestAssert(Triangle::zero.isZero());
}
//------------------------------------------------------------------------------
// ϊeXg
void TriangleTest::testTransform(){
	Triangle triangle0(1.f, 2.f, 3.f, 3.f, 2.f, 1.f, 1.f, 3.f, 2.f);
	Triangle triangle1(Triangle::zero);

	Matrix33 mtx33;
	mtx33.setScale(Vector3(1.f, 2.f, 1.f));
	mtx33.addRotationXYZ(Vector3(Math::halfPI, Math::halfPI, Math::halfPI));
	triangle1 = triangle0.transform(mtx33);
	TestAssert(triangle1.epsilonEquals(
		Triangle(3.f, 4.f, -1.f, 1.f, 4.f, -3.f, 2.f, 6.f, -1.f),
		Math::epsilon));

	Matrix34 mtx43;
	mtx43.setScale(Vector3(1.f, 2.f, 1.f));
	mtx43.addRotationXYZ(Vector3(Math::halfPI, Math::halfPI, Math::halfPI));
	mtx43.addTranslation(1.f, 1.f, 1.f);
	triangle1 = triangle0.transform(mtx43);
	TestAssert(triangle1.epsilonEquals(
		Triangle(4.f, 5.f, 0.f, 2.f, 5.f, -2.f, 3.f, 7.f, 0.f), Math::epsilon));

	Matrix44 mtx44;
	mtx44.setScale(Vector3(1.f, 2.f, 1.f));
	mtx44.addRotationXYZ(Vector3(Math::halfPI, Math::halfPI, Math::halfPI));
	mtx44.addTranslation(1.f, -1.f, 1.f);
	triangle1 = triangle0.transform(mtx44);
	TestAssert(triangle1.epsilonEquals(
		Triangle(4.f, 3.f, 0.f, 2.f, 3.f, -2.f, 3.f, 5.f, 0.f), Math::epsilon));
}
//------------------------------------------------------------------------------
// _ZeXg
void TriangleTest::testLogicalOperation(){
	Triangle triangle0(Vector3(0.f, 0.f, 0.f), Vector3(1.f, 1.f, 1.f),
		Vector3(2.f, 2.f, 2.f));
	Triangle triangle1(Vector3(1.f, 1.f, 1.f), Vector3(2.f, 2.f, 2.f),
		Vector3(3.f, 3.f, 3.f));
	Triangle triangle2(Vector3(0.f, 0.f, 0.f), Vector3(1.f, 1.f, 1.f),
		Vector3(2.f, 2.f, 2.f));
	TestAssert(!(triangle0 == triangle1));
	TestAssert(triangle0 == triangle2);
	TestAssert(triangle0 != triangle1);
	TestAssert(!(triangle0 != triangle2));
	TestAssert(triangle0.epsilonEquals(triangle1, 1.f));
	TestAssert(triangle0 != triangle1);
	TestAssert(triangle0.notEpsilonEquals(triangle1, 0.5f));
	TestAssert(!triangle0.notEpsilonEquals(triangle1, 1.f));
	TestAssert(!triangle0.notEpsilonEquals(triangle2, 0.f));
}
//------------------------------------------------------------------------------
// eXg
void TriangleTest::testToString(){
	Triangle triangle0(12345678.f, 1234.5678f, 0.12345678f,
		12345678.f, 1234.5678f, 0.12345678f,
		12345678.f, 1234.5678f, 0.12345678f);
	TestEquals("{ ( 12345678.00000000, 1234.56774902, 0.12345678 ) "
		"( 12345678.00000000, 1234.56774902, 0.12345678 ) "
		"( 12345678.00000000, 1234.56774902, 0.12345678 ) }",
		triangle0.toString());
}
//------------------------------------------------------------------------------
