//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * CeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Primitive/LineTest.h"
#include "Geometry/Primitive/Line.h"

//------------------------------------------------------------------------------
// RXgN^
LineTest::LineTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* LineTest::suite(){
	TestSuite* suite = new TestSuite("LineTest");
	suite->addTest(new TestCaller(LineTest, testConstructor));
	suite->addTest(new TestCaller(LineTest, testFixedNumber));
	suite->addTest(new TestCaller(LineTest, testSetValue));
	suite->addTest(new TestCaller(LineTest, testGetValue));
	suite->addTest(new TestCaller(LineTest, testLineArithmetic));
	suite->addTest(new TestCaller(LineTest, testTransform));
	suite->addTest(new TestCaller(LineTest, testLogicalOperation));
	suite->addTest(new TestCaller(LineTest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void LineTest::testConstructor(){
	TestEquals(24, (int)sizeof(Line));
	Line line0(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f);
	Line line1(Vector3(-1.f, -2.f, -3.f), Vector3(1.f, 2.f, 3.f));
	TestAssert(line0 == line1);
	Line line2(line1);
	TestAssert(line0 == line2);
	line1 = line2;
	TestAssert(line0 == line1);
	Line line3(Line::zero);
	TestAssert(line3 == Line(0.f, 0.f, 0.f, 0.f, 0.f, 0.f));
	float array[] = { -1.f, -2.f, -3.f, 1.f, 2.f, 3.f };
	Line line4(array);
	TestAssert(line0 == line4);
}
//------------------------------------------------------------------------------
// 萔eXg
void LineTest::testFixedNumber(){
	Line line0(0.f, 0.f, 0.f, 0.f, 0.f, 0.f);
	TestAssert(line0 == Line::zero);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void LineTest::testSetValue(){
	Line line0(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f);
	Line line1;
	line1.set(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f);
	TestAssert(line0 == line1);
	line1.set(Vector3(-1.f, -2.f, -3.f), Vector3(1.f, 2.f, 3.f));
	TestAssert(line0 == line1);
	float array[] = { -1.f, -2.f, -3.f, 1.f, 2.f, 3.f };
	line1.set(array);
}
//------------------------------------------------------------------------------
// l̎擾eXg
void LineTest::testGetValue(){
	Line line0(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f);
	TestAssert(line0.getOrigin() == Vector3(-1.f, -2.f, -3.f));
	TestAssert(line0.getDirection() == Vector3(1.f, 2.f, 3.f));
}
//------------------------------------------------------------------------------
// CZ
void LineTest::testLineArithmetic(){
	TestAssert(Line(0.f, 0.f, 0.f, 0.f, 0.f, 0.f).isZero());
	TestAssert(Line(1.f, 2.f, 3.f, 0.f, 0.f, 0.f).isZero());
}
//------------------------------------------------------------------------------
// ϊeXg
void LineTest::testTransform(){
	Line line0(1.f, 2.f, 3.f, 1.f, 2.f, 3.f);
	Line line1(Line::zero);

	Matrix33 mtx33;
	mtx33.setScale(Vector3(1.f, 2.f, 1.f));
	mtx33.addRotationXYZ(Vector3(Math::halfPI, Math::halfPI, Math::halfPI));
	line1 = line0.transform(mtx33);
	TestAssert(line1.epsilonEquals(
		Line(3.f, 4.f, -1.f, 3.f, 4.f, -1.f), Math::epsilon));

	Matrix34 mtx43;
	mtx43.setScale(Vector3(1.f, 2.f, 1.f));
	mtx43.addRotationXYZ(Vector3(Math::halfPI, Math::halfPI, Math::halfPI));
	mtx43.addTranslation(1.f, 1.f, 1.f);
	line1 = line0.transform(mtx43);
	TestAssert(line1.epsilonEquals(
		Line(4.f, 5.f, 0.f, 3.f, 4.f, -1.f), Math::epsilon));

	Matrix44 mtx44;
	mtx44.setScale(Vector3(1.f, 2.f, 1.f));
	mtx44.addRotationXYZ(Vector3(Math::halfPI, Math::halfPI, Math::halfPI));
	mtx44.addTranslation(1.f, -1.f, 1.f);
	line1 = line0.transform(mtx44);
	TestAssert(line1.epsilonEquals(
		Line(4.f, 3.f, 0.f, 3.f, 4.f, -1.f), Math::epsilon));
}
//------------------------------------------------------------------------------
// _ZeXg
void LineTest::testLogicalOperation(){
	Line line0(0.f, 0.f, 0.f, 1.f, 1.f, 1.f),
		line1(1.f, 1.f, 1.f, 2.f, 2.f, 2.f),
		line2(0.f, 0.f, 0.f, 1.f, 1.f, 1.f);
	TestAssert(!(line0 == line1));
	TestAssert(line0 == line2);
	TestAssert(line0 != line1);
	TestAssert(!(line0 != line2));
	TestAssert(line0.epsilonEquals(line1, 1.f));
	TestAssert(line0 != line1);
	TestAssert(line0.notEpsilonEquals(line1, 0.5f));
	TestAssert(!line0.notEpsilonEquals(line1, 1.f));
	TestAssert(!line0.notEpsilonEquals(line2, 0.f));
}
//------------------------------------------------------------------------------
// eXg
void LineTest::testToString(){
	Line line0(12345678.f, 1234.5678f, 0.12345678f,
		12345678.f, 1234.5678f, 0.12345678f);
	TestEquals("{ ( 12345678.00000000, 1234.56774902, 0.12345678 ) "
		"( 12345678.00000000, 1234.56774902, 0.12345678 ) }",
		line0.toString());
}
//------------------------------------------------------------------------------
