//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * SẴWIgv~eBueXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Primitive/GeometryPrimitiveAllTests.h"

#include "Geometry/Primitive/AxisAlignedBoxTest.h"
#include "Geometry/Primitive/CapsuleTest.h"
#include "Geometry/Primitive/ConeTest.h"
#include "Geometry/Primitive/LineTest.h"
#include "Geometry/Primitive/OrientedBoxTest.h"
#include "Geometry/Primitive/PlaneTest.h"
#include "Geometry/Primitive/RayTest.h"
#include "Geometry/Primitive/SegmentTest.h"
#include "Geometry/Primitive/SphereTest.h"
#include "Geometry/Primitive/TriangleTest.h"

//------------------------------------------------------------------------------
// RXgN^
GeometryPrimitiveAllTests::GeometryPrimitiveAllTests() :
	TestSuite("GeometryPrimitiveAllTests"){
	// {bNX̃eXg
	addTest(AxisAlignedBoxTest::suite());
	// JvZ̃eXg
	addTest(CapsuleTest::suite());
	// R[̃eXg
	addTest(ConeTest::suite());
	// C̃eXg
	addTest(LineTest::suite());
	// w{bNX̃eXg
	addTest(OrientedBoxTest::suite());
	// ʂ̃eXg
	addTest(PlaneTest::suite());
	// C̃eXg
	addTest(RayTest::suite());
	// ZOg̃eXg
	addTest(SegmentTest::suite());
	// ̃eXg
	addTest(SphereTest::suite());
	// Op̃eXg
	addTest(TriangleTest::suite());
}
//------------------------------------------------------------------------------
