//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ό`bVeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Mesh/DeformedMeshGeometryTest.h"
#include "Geometry/Mesh/DeformedMeshGeometry.h"

//------------------------------------------------------------------------------
// RXgN^
DeformedMeshGeometryTest::DeformedMeshGeometryTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* DeformedMeshGeometryTest::suite(){
	TestSuite* suite = new TestSuite("DeformedMeshGeometryTest");
	suite->addTest(new TestCaller(DeformedMeshGeometryTest, testConstructor));
	suite->addTest(new TestCaller(DeformedMeshGeometryTest, testCopy));
	suite->addTest(new TestCaller(DeformedMeshGeometryTest, testSetGetValue));
	suite->addTest(new TestCaller(DeformedMeshGeometryTest, testBounding));
	suite->addTest(new TestCaller(DeformedMeshGeometryTest, testIntersection));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void DeformedMeshGeometryTest::testConstructor(){
	TestEquals(52, (int)sizeof(DeformedMeshGeometry));
	DeformedMeshGeometry mesh0;
	DeformedMeshGeometry mesh1;
	mesh1.setTriangleCount(16);
	DeformedMeshGeometry* mesh2 = new DeformedMeshGeometry();
	mesh2->setTriangleCount(64);
	mesh2->setTriangleCount(32);
	delete(mesh2);
}
//------------------------------------------------------------------------------
// Rs[eXg
void DeformedMeshGeometryTest::testCopy(){
	DeformedMeshGeometry mesh0;
	mesh0.setTriangleCount(1);
	Triangle triangle(1.f, 0.f, 0.f, -1.f, 0.f, 0.f, 0.f, 1.f, 0.f);
	mesh0.setTriangle(0, triangle);
	mesh0.calculateBounding();

	DeformedMeshGeometry mesh1(mesh0);
	TestEquals(1, mesh1.getTriangleCount());
	TestAssert(triangle == mesh1.getTriangle(0));
	TestAssert(AxisAlignedBox(-1.f, 0.f, 0.f, 1.f, 1.f, 0.f) ==
		mesh1.getBoundingBox());
	TestAssert(mesh1.getBoundingSphere().epsilonEquals(
		Sphere(0.f, 0.5f, 0.f, 1.1180340f), Math::epsilon));

	DeformedMeshGeometry mesh2;
	mesh2.setTriangleCount(10);
	mesh2 = mesh0;
	TestEquals(1, mesh2.getTriangleCount());
	TestAssert(triangle == mesh2.getTriangle(0));
	TestAssert(AxisAlignedBox(-1.f, 0.f, 0.f, 1.f, 1.f, 0.f) ==
		mesh2.getBoundingBox());
	TestAssert(mesh2.getBoundingSphere().epsilonEquals(
		Sphere(0.f, 0.5f, 0.f, 1.1180340f), Math::epsilon));
}
//------------------------------------------------------------------------------
// l̐ݒ擾eXg
void DeformedMeshGeometryTest::testSetGetValue(){
	DeformedMeshGeometry mesh0;
	TestEquals(0, mesh0.getTriangleCount());
	mesh0.setTriangleCount(1);
	TestEquals(1, mesh0.getTriangleCount());
	Triangle triangle(0.f, 1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f);
	mesh0.setTriangle(0, triangle);
	TestAssert(triangle == mesh0.getTriangle(0));

	AxisAlignedBox box(-1.f, 0.f, 0.f, 1.f, 1.f, 0.f);
	Sphere sphere(0.f, 0.5f, 0.f, 1.1180340f);
	mesh0.setBoundingBox(box);
	mesh0.setBoundingSphere(sphere);
	TestAssert(box == mesh0.getBoundingBox());
	TestAssert(sphere == mesh0.getBoundingSphere());
}
//------------------------------------------------------------------------------
// oEfBOeXg
void DeformedMeshGeometryTest::testBounding(){
	DeformedMeshGeometry mesh0;
	mesh0.setTriangleCount(1);
	Triangle triangle(1.f, 0.f, 0.f, -1.f, 0.f, 0.f, 0.f, 1.f, 0.f);
	mesh0.setTriangle(0, triangle);
	mesh0.calculateBounding();
	TestAssert(AxisAlignedBox(-1.f, 0.f, 0.f, 1.f, 1.f, 0.f) ==
		mesh0.getBoundingBox());
	TestAssert(mesh0.getBoundingSphere().epsilonEquals(
		Sphere(0.f, 0.5f, 0.f, 1.1180340f), Math::epsilon));
}
//------------------------------------------------------------------------------
// eXg
void DeformedMeshGeometryTest::testIntersection(){
	DeformedMeshGeometry mesh0;
	mesh0.setTriangleCount(2);
	Triangle triangle0(0.f, 0.f, 0.f, 0.f, 0.f, 1.f, 1.f, 0.f, 0.f);
	mesh0.setTriangle(0, triangle0);
	Triangle triangle1(1.f, 0.f, 0.f, 0.f, 0.f, -1.f, -1.f, 0.f, 0.f);
	mesh0.setTriangle(1, triangle1);
	mesh0.calculateBounding();
	Sphere sphere(0.f, 0.f, 0.f, 1.f);
	TestAssert(!mesh0.intersect(sphere));
	sphere.setCenter(0.f, 0.5f, 0.f);
	TestAssert(mesh0.intersect(sphere));
	sphere.setCenter(0.f, -0.5f, 0.f);
	TestAssert(!mesh0.intersect(sphere));
	sphere.setCenter(0.f, 1.f, 0.f);
	TestAssert(mesh0.intersect(sphere));
	sphere.setCenter(1.5f, 0.5f, 0.f);
	TestAssert(mesh0.intersect(sphere));
	sphere.setCenter(1.1f, 1.f, 0.f);
	TestAssert(!mesh0.intersect(sphere));
	sphere.setCenter(0.f, 0.5f, -1.5f);
	TestAssert(mesh0.intersect(sphere));
	sphere.setCenter(0.f, 1.f, -1.1f);
	TestAssert(!mesh0.intersect(sphere));
	sphere.setCenter(-0.6f, 0.5f, -0.6f);
	TestAssert(mesh0.intersect(sphere));
}
//------------------------------------------------------------------------------
