//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Intersection/SphereIntersectionTest.h"
#include "Geometry/System/Intersection.h"

//------------------------------------------------------------------------------
// RXgN^
SphereIntersectionTest::SphereIntersectionTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* SphereIntersectionTest::suite(){
	TestSuite* suite = new TestSuite("SphereIntersectionTest");
	suite->addTest(new TestCaller(SphereIntersectionTest, testPoint));
	suite->addTest(new TestCaller(SphereIntersectionTest, testSphere));
	suite->addTest(new TestCaller(SphereIntersectionTest, testTriangle));
	return suite;
}
//------------------------------------------------------------------------------
// _eXg
void SphereIntersectionTest::testPoint(){
}
//------------------------------------------------------------------------------
// eXg
void SphereIntersectionTest::testSphere(){
	Sphere sphere0(0.f, 0.f, 0.f, 5.f);
	Sphere sphere1(0.f, 0.f, 0.f, 5.f);
	TestAssert(sphere0.intersect(sphere1));
	sphere1.set(10.f, 0.f, 0.f, 5.f);
	TestAssert(sphere0.intersect(sphere1));
	sphere1.set(10.f + Math::epsilon, 0.f, 0.f, 5.f);
	TestAssert(!sphere0.intersect(sphere1));

	Intersection intersection;
	sphere0.set(0.f, 0.f, 0.f, 5.f);
	sphere1.set(0.f, 0.f, 0.f, 5.f);
	TestAssert(sphere0.intersect(&intersection, sphere1));
	TestAssert(intersection.getPosition() == Vector3(0.f, 5.f, 0.f));
	TestAssert(intersection.getRefrection() == Vector3(0.f, 10.f, 0.f));
	sphere1.set(0.f, 10.f, 0.f, 5.f);
	TestAssert(sphere0.intersect(&intersection, sphere1));
	TestAssert(intersection.getPosition() == Vector3(0.f, 5.f, 0.f));
	TestAssert(intersection.getRefrection() == Vector3(0.f, 0.f, 0.f));
	sphere1.set(5.f, 5.f, 5.f, 5.f);
	TestAssert(sphere0.intersect(&intersection, sphere1));
	TestAssert(intersection.getPosition().epsilonEquals(
		Vector3(2.88675094f, 2.88675094f, 2.88675094f), Math::epsilon));
	TestAssert(intersection.getRefrection().epsilonEquals(
		Vector3(0.77350265f, 0.77350265f, 0.77350265f), Math::epsilon));

}
//------------------------------------------------------------------------------
// OpeXg
void SphereIntersectionTest::testTriangle(){
	Sphere sphere;
	Triangle triangle;




	Intersection intersection;
	triangle.set(0.f, 0.f, 0.f, 0.f, 0.f, 1.f, 1.f, 0.f, 0.f);
	// ȂeXg
	sphere.set(0.1f, 0.f, 0.1f, 1.f);
	TestAssert(!sphere.intersect(&intersection, triangle));
	TestAssert(!triangle.intersect(&intersection, sphere));
	sphere.set(0.1f, 1.1f, 0.1f, 1.f);
	TestAssert(!sphere.intersect(&intersection, triangle));
	TestAssert(!triangle.intersect(&intersection, sphere));
	sphere.set(0.1f, -0.1f, 0.1f, 1.f);
	TestAssert(!sphere.intersect(&intersection, triangle));
	TestAssert(!triangle.intersect(&intersection, sphere));
	sphere.set(0.6f, 0.5f, 0.6f, 0.5f);
	TestAssert(!sphere.intersect(&intersection, triangle));
	TestAssert(!triangle.intersect(&intersection, sphere));
	sphere.set(1.1f, 0.5f, 0.f, 0.5f);
	TestAssert(!sphere.intersect(&intersection, triangle));
	TestAssert(!triangle.intersect(&intersection, sphere));
	// Op`
	sphere.set(0.1f, 0.5f, 0.1f, 1.f);
	triangle.set(0.f, 0.f, 0.f, 0.f, 0.f, 1.f, 1.f, 0.f, 0.f);
	TestAssert(sphere.intersect(&intersection, triangle));
	TestAssert(intersection.getPosition() == Vector3(0.1f, -0.5f, 0.1f));
	TestAssert(intersection.getRefrection() == Vector3(0.f, -0.5f, 0.f));
	TestAssert(triangle.intersect(&intersection, sphere));
	TestAssert(intersection.getPosition() == Vector3(0.1f, 0.f, 0.1f));
	TestAssert(intersection.getRefrection() == Vector3(0.f, 0.5f, 0.f));
	// GbW
	sphere.set(0.75f, 0.1f, 0.75f, 0.5f);
	TestAssert(sphere.intersect(&intersection, triangle));
	TestAssert(intersection.getPosition().epsilonEquals(
		Vector3(0.40979311f, -0.03608275f, 0.40979311f), Math::epsilon));
	TestAssert(intersection.getRefrection().epsilonEquals(
		Vector3(-0.09020689f, -0.03608276f, -0.09020689f), Math::epsilon));
	TestAssert(triangle.intersect(&intersection, sphere));
	TestAssert(intersection.getPosition().epsilonEquals(
		Vector3(0.5f, 0.f, 0.5f), Math::epsilon));
	TestAssert(intersection.getRefrection().epsilonEquals(
		Vector3(0.09020689f, 0.03608276f, 0.09020689f), Math::epsilon));
	// _
	sphere.set(1.5f, 0.1f, 0.f, 1.f);
	TestAssert(sphere.intersect(&intersection, triangle));
	TestAssert(intersection.getPosition().epsilonEquals(
		Vector3(0.51941931f, -0.09611613f, 0.f), Math::epsilon));
	TestAssert(intersection.getRefrection().epsilonEquals(
		Vector3(-0.48058069f, -0.09611614f, 0.f), Math::epsilon));
	TestAssert(triangle.intersect(&intersection, sphere));
	TestAssert(intersection.getPosition().epsilonEquals(
		Vector3(1.f, 0.f, 0.f), Math::epsilon));
	TestAssert(intersection.getRefrection().epsilonEquals(
		Vector3(0.48058069f, 0.09611614f, 0.f), Math::epsilon));
}
//------------------------------------------------------------------------------
