//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * CeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Intersection/RayIntersectionTest.h"

//------------------------------------------------------------------------------
// RXgN^
RayIntersectionTest::RayIntersectionTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* RayIntersectionTest::suite(){
	TestSuite* suite = new TestSuite("RayIntersectionTest");
	suite->addTest(new TestCaller(RayIntersectionTest, testPoint));
	suite->addTest(new TestCaller(RayIntersectionTest, testRay));
	suite->addTest(new TestCaller(RayIntersectionTest, testSegment));
	suite->addTest(new TestCaller(RayIntersectionTest, testSphere));
	suite->addTest(new TestCaller(RayIntersectionTest, testTriangle));
	return suite;
}
//------------------------------------------------------------------------------
// _eXg
void RayIntersectionTest::testPoint(){
}
//------------------------------------------------------------------------------
// CeXg
void RayIntersectionTest::testRay(){
	Ray ray0(0.f, 0.f, 0.f, 0.f, 1.f, 0.f);
	Ray ray1(0.f, 2.f, 0.f, 0.f, 1.f, 0.f);
	TestAssert(ray0.intersect(ray1));
	ray1.setOrigin(Vector3(1.f, 0.f, 0.f));
	TestAssert(!ray0.intersect(ray1));
	ray1.setDirection(Vector3(1.f, 0.f, 0.f));
	TestAssert(!ray0.intersect(ray1));
	ray1.setOrigin(Vector3(-1.f, 0.f, 0.f));
	TestAssert(ray0.intersect(ray1));
}
//------------------------------------------------------------------------------
// ZOgeXg
void RayIntersectionTest::testSegment(){
}
//------------------------------------------------------------------------------
// eXg
void RayIntersectionTest::testSphere(){
}
//------------------------------------------------------------------------------
// OpeXg
void RayIntersectionTest::testTriangle(){
}
//------------------------------------------------------------------------------
