//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ʌeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Intersection/PlaneIntersectionTest.h"

//------------------------------------------------------------------------------
// RXgN^
PlaneIntersectionTest::PlaneIntersectionTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* PlaneIntersectionTest::suite(){
	TestSuite* suite = new TestSuite("PlaneIntersectionTest");
	suite->addTest(new TestCaller(PlaneIntersectionTest, testPoint));
	suite->addTest(new TestCaller(PlaneIntersectionTest, testPlane));
	suite->addTest(new TestCaller(PlaneIntersectionTest, testRay));
	suite->addTest(new TestCaller(PlaneIntersectionTest, testSegment));
	suite->addTest(new TestCaller(PlaneIntersectionTest, testSphere));
	suite->addTest(new TestCaller(PlaneIntersectionTest, testTriangle));
	return suite;
}
//------------------------------------------------------------------------------
// _eXg
void PlaneIntersectionTest::testPoint(){
}
//------------------------------------------------------------------------------
// ʃeXg
void PlaneIntersectionTest::testPlane(){
	Plane plane0(0.f, 1.f, 0.f, 0.f);
	Plane plane1(0.f, 1.f, 0.f, 0.f);
	TestAssert(!plane0.intersect(plane1));
	plane1.set(0.f, -1.f, 0.f, 0.f);
	TestAssert(!plane0.intersect(plane1));
	plane1.set(1.f, 0.f, 0.f, 0.f);
	TestAssert(plane0.intersect(plane1));
}
//------------------------------------------------------------------------------
// CeXg
void PlaneIntersectionTest::testRay(){
}
//------------------------------------------------------------------------------
// ZOgeXg
void PlaneIntersectionTest::testSegment(){
}
//------------------------------------------------------------------------------
// eXg
void PlaneIntersectionTest::testSphere(){
}
//------------------------------------------------------------------------------
// OpeXg
void PlaneIntersectionTest::testTriangle(){
}
//------------------------------------------------------------------------------
