//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * CeXgwb_
 * @author Junpee
 */

#ifndef LINE_INTERSECTION_TEST_H_
#define LINE_INTERSECTION_TEST_H_

#include <LampUnit/TestCase.h>

//------------------------------------------------------------------------------
/**
 * CeXg
 */
class LineIntersectionTest : public TestCase{
public:
	/**
	 * RXgN^
	 * @param name eXg̖O
	 */
	explicit LineIntersectionTest(String name);

	/**
	 * eXgs
	 */
	virtual void runTest(){}

	/**
	 * eXgXB[g̎擾
	 * @return eXgXB[g
	 */
	static Test* suite();

	// _eXg
	virtual void testPoint();

	// CeXg
	virtual void testLine();

	// w{bNXeXg
	virtual void testOrientedBox();

	// ʃeXg
	virtual void testPlane();

	// CeXg
	virtual void testRay();

	// ZOgeXg
	virtual void testSegment();

	// eXg
	virtual void testSphere();

	// OpeXg
	virtual void testTriangle();

private:

};

//------------------------------------------------------------------------------
#endif // End of LINE_INTERSECTION_TEST_H_
//------------------------------------------------------------------------------
