//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * CeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Intersection/LineIntersectionTest.h"

//------------------------------------------------------------------------------
// RXgN^
LineIntersectionTest::LineIntersectionTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* LineIntersectionTest::suite(){
	TestSuite* suite = new TestSuite("LineIntersectionTest");
	suite->addTest(new TestCaller(LineIntersectionTest, testPoint));
	suite->addTest(new TestCaller(LineIntersectionTest, testLine));
	suite->addTest(new TestCaller(LineIntersectionTest, testOrientedBox));
	suite->addTest(new TestCaller(LineIntersectionTest, testPlane));
	suite->addTest(new TestCaller(LineIntersectionTest, testRay));
	suite->addTest(new TestCaller(LineIntersectionTest, testSegment));
	suite->addTest(new TestCaller(LineIntersectionTest, testSphere));
	suite->addTest(new TestCaller(LineIntersectionTest, testTriangle));
	return suite;
}
//------------------------------------------------------------------------------
// _eXg
void LineIntersectionTest::testPoint(){
}
//------------------------------------------------------------------------------
// CeXg
void LineIntersectionTest::testLine(){
	Line line0(0.f, 0.f, 0.f, 0.f, 1.f, 0.f);
	Line line1(0.f, 2.f, 0.f, 0.f, 1.f, 0.f);
	TestAssert(line0.intersect(line1));
	line1.setOrigin(Vector3(1.f, 0.f, 0.f));
	TestAssert(!line0.intersect(line1));
	line1.setDirection(Vector3(1.f, 0.f, 0.f));
	TestAssert(line0.intersect(line1));
	line1.setOrigin(Vector3(-1.f, 0.f, 0.f));
	TestAssert(line0.intersect(line1));
}
//------------------------------------------------------------------------------
// w{bNXeXg
void LineIntersectionTest::testOrientedBox(){
}
//------------------------------------------------------------------------------
// ʃeXg
void LineIntersectionTest::testPlane(){
}
//------------------------------------------------------------------------------
// CeXg
void LineIntersectionTest::testRay(){
}
//------------------------------------------------------------------------------
// ZOgeXg
void LineIntersectionTest::testSegment(){
}
//------------------------------------------------------------------------------
// eXg
void LineIntersectionTest::testSphere(){
}
//------------------------------------------------------------------------------
// OpeXg
void LineIntersectionTest::testTriangle(){
}
//------------------------------------------------------------------------------
