//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {bNXeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersectionTest.h"

//------------------------------------------------------------------------------
// RXgN^
AxisAlignedBoxIntersectionTest::AxisAlignedBoxIntersectionTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* AxisAlignedBoxIntersectionTest::suite(){
	TestSuite* suite = new TestSuite("AxisAlignedBoxIntersectionTest");
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testPoint));
	suite->addTest(new TestCaller(
		AxisAlignedBoxIntersectionTest, testAxisAlignedBox));
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testCapsule));
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testCone));
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testLine));
	suite->addTest(new TestCaller(
		AxisAlignedBoxIntersectionTest, testOrientedBox));
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testPlane));
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testRay));
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testSegment));
	suite->addTest(new TestCaller(AxisAlignedBoxIntersectionTest, testSphere));
	suite->addTest(new TestCaller(
		AxisAlignedBoxIntersectionTest, testTriangle));
	return suite;
}
//------------------------------------------------------------------------------
// _eXg
void AxisAlignedBoxIntersectionTest::testPoint(){
}
//------------------------------------------------------------------------------
// {bNXeXg
void AxisAlignedBoxIntersectionTest::testAxisAlignedBox(){
	AxisAlignedBox box0(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f);
	AxisAlignedBox box1(-1.f, -2.f, -3.f, 1.f, 2.f, 3.f);
	TestAssert(box0.intersect(box1));
	box1.set(-1.f, -2.f, -3.f, -1.f, -2.f, -3.f);
	TestAssert(box0.intersect(box1));
	box1.set(1.f, 2.f, 3.f, 1.f, 2.f, 3.f);
	TestAssert(box0.intersect(box1));
	box1.set(1.f, 2.f, 3.f, 4.f, 5.f, 6.f);
	TestAssert(box0.intersect(box1));
	box1.set(1.f + Math::epsilon, 2.f, 3.f, 4.f, 5.f, 6.f);
	TestAssert(!box0.intersect(box1));
}
//------------------------------------------------------------------------------
// JvZeXg
void AxisAlignedBoxIntersectionTest::testCapsule(){
}
//------------------------------------------------------------------------------
// R[eXg
void AxisAlignedBoxIntersectionTest::testCone(){
}
//------------------------------------------------------------------------------
// CeXg
void AxisAlignedBoxIntersectionTest::testLine(){
}
//------------------------------------------------------------------------------
// w{bNXeXg
void AxisAlignedBoxIntersectionTest::testOrientedBox(){
}
//------------------------------------------------------------------------------
// ʃeXg
void AxisAlignedBoxIntersectionTest::testPlane(){
}
//------------------------------------------------------------------------------
// CeXg
void AxisAlignedBoxIntersectionTest::testRay(){
}
//------------------------------------------------------------------------------
// ZOgeXg
void AxisAlignedBoxIntersectionTest::testSegment(){
}
//------------------------------------------------------------------------------
// eXg
void AxisAlignedBoxIntersectionTest::testSphere(){
}
//------------------------------------------------------------------------------
// OpeXg
void AxisAlignedBoxIntersectionTest::testTriangle(){
}
//------------------------------------------------------------------------------
