//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * SẴWIgeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/GeometryAllTests.h"

#include "Geometry/Primitive/GeometryPrimitiveAllTests.h"
#include "Geometry/Distance/GeometryDistanceAllTests.h"
#include "Geometry/Intersection/GeometryIntersectionAllTests.h"
#include "Geometry/Mesh/GeometryMeshAllTests.h"

//------------------------------------------------------------------------------
// RXgN^
GeometryAllTests::GeometryAllTests() : TestSuite("GeometryAllTests"){
	// v~eBueXg
	addTest(new GeometryPrimitiveAllTests());
	// eXg
	addTest(new GeometryDistanceAllTests());
	// eXg
	addTest(new GeometryIntersectionAllTests());
	// bVeXg
	addTest(new GeometryMeshAllTests());
}
//------------------------------------------------------------------------------
