//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * CeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Distance/RayDistanceTest.h"

//------------------------------------------------------------------------------
// RXgN^
RayDistanceTest::RayDistanceTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* RayDistanceTest::suite(){
	TestSuite* suite = new TestSuite("RayDistanceTest");
	suite->addTest(new TestCaller(RayDistanceTest, testPoint));
	suite->addTest(new TestCaller(RayDistanceTest, testRay));
	suite->addTest(new TestCaller(RayDistanceTest, testSegment));
	suite->addTest(new TestCaller(RayDistanceTest, testSphere));
	suite->addTest(new TestCaller(RayDistanceTest, testTriangle));
	return suite;
}
//------------------------------------------------------------------------------
// _eXg
void RayDistanceTest::testPoint(){
}
//------------------------------------------------------------------------------
// CeXg
void RayDistanceTest::testRay(){
	Ray ray0(0.f, 0.f, 0.f, 0.f, 1.f, 0.f);
	TestEquals(0.f, ray0.getDistance(Vector3(0.f, 2.f, 0.f)));
	TestEquals(1.f, ray0.getDistance(Vector3(0.f, -1.f, 0.f)));
	TestEquals(1.f, ray0.getDistance(Vector3(1.f, 0.f, 0.f)));
	Ray ray1(0.f, 2.f, 0.f, 0.f, 1.f, 0.f);
	TestEquals(0.f, ray0.getDistance(ray1));
	ray1.setOrigin(Vector3(1.f, 0.f, 0.f));
	TestEquals(1.f, ray0.getDistance(ray1));
	ray1.setDirection(Vector3(1.f, 0.f, 0.f));
	TestEquals(1.f, ray0.getDistance(ray1));
	ray1.setOrigin(Vector3(-1.f, 0.f, 0.f));
	TestEquals(0.f, ray0.getDistance(ray1));
}
//------------------------------------------------------------------------------
// ZOgeXg
void RayDistanceTest::testSegment(){
}
//------------------------------------------------------------------------------
// eXg
void RayDistanceTest::testSphere(){
}
//------------------------------------------------------------------------------
// OpeXg
void RayDistanceTest::testTriangle(){
}
//------------------------------------------------------------------------------
