//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ʋeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Geometry/Distance/PlaneDistanceTest.h"

//------------------------------------------------------------------------------
// RXgN^
PlaneDistanceTest::PlaneDistanceTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* PlaneDistanceTest::suite(){
	TestSuite* suite = new TestSuite("PlaneDistanceTest");
	suite->addTest(new TestCaller(PlaneDistanceTest, testPoint));
	suite->addTest(new TestCaller(PlaneDistanceTest, testPlane));
	suite->addTest(new TestCaller(PlaneDistanceTest, testRay));
	suite->addTest(new TestCaller(PlaneDistanceTest, testSegment));
	suite->addTest(new TestCaller(PlaneDistanceTest, testSphere));
	suite->addTest(new TestCaller(PlaneDistanceTest, testTriangle));
	return suite;
}
//------------------------------------------------------------------------------
// _eXg
void PlaneDistanceTest::testPoint(){
}
//------------------------------------------------------------------------------
// ʃeXg
void PlaneDistanceTest::testPlane(){
	Plane plane0(0.f, 1.f, 0.f, -1.f);
	TestEquals(1.f, plane0.getDistance(Vector3(0.f, 2.f, 0.f)));
	TestEquals(-3.f, plane0.getDistance(Vector3(0.f, -2.f, 0.f)));
}
//------------------------------------------------------------------------------
// CeXg
void PlaneDistanceTest::testRay(){
}
//------------------------------------------------------------------------------
// ZOgeXg
void PlaneDistanceTest::testSegment(){
}
//------------------------------------------------------------------------------
// eXg
void PlaneDistanceTest::testSphere(){
}
//------------------------------------------------------------------------------
// OpeXg
void PlaneDistanceTest::testTriangle(){
}
//------------------------------------------------------------------------------
