//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XgOg[NiCŨeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Utility/StringTokenizerTest.h"
#include <Core/Utility/StringTokenizer.h>

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* StringTokenizerTest::suite(){
	TestSuite* suite = new TestSuite("StringTokenizerTest");
	suite->addTest(new TestCaller(StringTokenizerTest, testDefaultTokenizer));
	suite->addTest(new TestCaller(StringTokenizerTest,
		testDelimiterTokenizer));
	suite->addTest(new TestCaller(StringTokenizerTest, testDetailTokenizer));
	return suite;
}
//------------------------------------------------------------------------------
// ftHgg[NiCUeXg
void StringTokenizerTest::testDefaultTokenizer(){
	String target(" @\t\n\r\f");
	StringTokenizer tokenizer(target);
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("@", tokenizer.getNextToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestEquals("@", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestEquals("", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestEquals("", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestEquals("", tokenizer.getPreviousToken());
	TestAssert(!tokenizer.hasMoreTokens());

	String target2("@\t\n\r");
	StringTokenizer tokenizer2(target2);
	TestAssert(tokenizer2.hasMoreTokens());
	TestEquals("@", tokenizer2.getNextToken());
	TestAssert(tokenizer2.hasMoreTokens());
	TestEquals("", tokenizer2.getNextToken());
	TestAssert(tokenizer2.hasMoreTokens());
	TestEquals("", tokenizer2.getNextToken());
	TestAssert(tokenizer2.hasMoreTokens());
	TestEquals("", tokenizer2.getNextToken());
	TestAssert(!tokenizer2.hasMoreTokens());

	tokenizer.initialize(target2);
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("@", tokenizer.getNextToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestAssert(!tokenizer.hasMoreTokens());
}
//------------------------------------------------------------------------------
// f~^g[NiCUeXg
void StringTokenizerTest::testDelimiterTokenizer(){
	String target(" @\t\n\r\f");
	StringTokenizer tokenizer(target, " @\t\r\f");
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("\n", tokenizer.getNextToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestAssert(!tokenizer.hasMoreTokens());
}
//------------------------------------------------------------------------------
// ڍ׃g[NiCUeXg
void StringTokenizerTest::testDetailTokenizer(){
	String target(" @\t\n\r\f");
	StringTokenizer tokenizer(target, " @\t\r\f", true);
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals(" ", tokenizer.getNextToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestEquals(" ", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("@", tokenizer.getNextToken());
	TestEquals("", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("\t", tokenizer.getNextToken());
	TestEquals("@", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("\n", tokenizer.getNextToken());
	TestEquals("\t", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("\r", tokenizer.getNextToken());
	TestEquals("\n", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("", tokenizer.getNextToken());
	TestEquals("\r", tokenizer.getPreviousToken());
	TestAssert(tokenizer.hasMoreTokens());
	TestEquals("\f", tokenizer.getNextToken());
	TestEquals("", tokenizer.getPreviousToken());
	TestAssert(!tokenizer.hasMoreTokens());
}
//------------------------------------------------------------------------------
