//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * _̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Utility/RandomTest.h"
#include "Core/Utility/Random.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* RandomTest::suite(){
	TestSuite* suite = new TestSuite("RandomTest");
	suite->addTest(new TestCaller(RandomTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {eXg
void RandomTest::testBasic(){
	Random random(134);
	// int
	for(int i = 0; i < 1690; i++){ random.get(); }
	TestEquals(0x7fffffu, (random.get() & 0x7fffff));
	for(int i = 0; i < 1193822; i++){ random.get(); }
	TestEquals(0u, (random.get() & 0x7fffff));
	// byte
	random.setSeed(134);
	for(int i = 0; i < 1690; i++){ random.get(); }
	TestEquals(255, random.getByte());
	for(int i = 0; i < 1193822; i++){ random.get(); }
	TestEquals(0, random.getByte());
	// u_float
	random.setSeed(134);
	for(int i = 0; i < 1690; i++){ random.get(); }
	TestEquals(0.99999988f, random.getUnsignedFloat());
	for(int i = 0; i < 1193822; i++){ random.get(); }
	TestEquals(0.f, random.getUnsignedFloat());
	// float
	random.setSeed(134);
	for(int i = 0; i < 1690; i++){ random.get(); }
	TestEquals(0.99999976f, random.getSignedFloat());
	for(int i = 0; i < 1193822; i++){ random.get(); }
	TestEquals(-1.f, random.getSignedFloat());
}
//------------------------------------------------------------------------------
