//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RtBO[Vt@C̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Utility/ConfigurationFileTest.h"
#include "Core/Utility/ConfigurationFile.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* ConfigurationFileTest::suite(){
	TestSuite* suite = new TestSuite("ConfigurationFileTest");
	suite->addTest(new TestCaller(ConfigurationFileTest, testLoad));
	return suite;
}
//------------------------------------------------------------------------------
// ǂݏoeXg
void ConfigurationFileTest::testLoad(){
	ConfigurationFile config("Resource/Core/Utility/ConfigurationFileTest.txt");
	TestEquals(11, config.getCount());
	char charValue;
	TestAssert(config.getChar("char", &charValue));
	TestEquals(-128, charValue);
	TestAssert(!config.getChar("String", &charValue));
	TestEquals(-128, charValue);

	u_char uCharValue;
	TestAssert(config.getUChar("u_char", &uCharValue));
	TestEquals(255, uCharValue);
	TestAssert(!config.getUChar("String", &uCharValue));
	TestEquals(255, uCharValue);

	short shortValue;
	TestAssert(config.getShort("short", &shortValue));
	TestEquals(-32768, shortValue);
	TestAssert(!config.getShort("String", &shortValue));
	TestEquals(-32768, shortValue);

	u_short uShortValue;
	TestAssert(config.getUShort("u_short", &uShortValue));
	TestEquals(65535, uShortValue);
	TestAssert(!config.getUShort("String", &uShortValue));
	TestEquals(65535, uShortValue);

	int intValue;
	TestAssert(config.getInt("int", &intValue));
	TestEquals(-2147483647 - 1, intValue);
	TestAssert(!config.getInt("String", &intValue));
	TestEquals(-2147483647 - 1, intValue);

	u_int uIntValue;
	TestAssert(config.getUInt("u_int", &uIntValue));
	TestEquals(4294967295, uIntValue);
	TestAssert(!config.getUInt("String", &uIntValue));
	TestEquals(4294967295, uIntValue);

	float floatValue;
	TestAssert(config.getFloat("float", &floatValue));
	TestEquals(-0.00001f, floatValue);
	TestAssert(!config.getFloat("String", &floatValue));
	TestEquals(-0.00001f, floatValue);

	double doubleValue;
	TestAssert(config.getDouble("double", &doubleValue));
	TestEquals(-1e-15, doubleValue);
	TestAssert(!config.getDouble("String", &doubleValue));
	TestEquals(-1e-15, doubleValue);

	String stringValue;
	TestAssert(config.getString("String", &stringValue));
	TestEquals("\\\"\t\v\b\f\a\r\n%%", stringValue);
	TestAssert(!config.getString("StringA", &stringValue));
	TestAssert(!config.getString("StringB", &stringValue));
	TestEquals("\\\"\t\v\b\f\a\r\n%%", stringValue);
}
//------------------------------------------------------------------------------
