//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 3Dw̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/System/Math3DTest.h"
#include <Core/System/Math3D.h>

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* Math3DTest::suite(){
	TestSuite* suite = new TestSuite("Math3DTest");
	suite->addTest(new TestCaller(Math3DTest, testCalculateNormal));
	return suite;
}
//------------------------------------------------------------------------------
// @vZeXg
void Math3DTest::testCalculateNormal(){
	Vector3 vec0 = Math3D::calculateNormal(Vector3(0.f, 1.f, 0.f),
		Vector3(0.f, 1.f, 1.f), Vector3(1.f, 1.f, 0.f));
	TestAssert(vec0 == Vector3(0.f, 1.f, 0.f));
}
//------------------------------------------------------------------------------
