//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OxNgeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/Vector3Test.h"
#include "Core/Primitive/Vector3.h"

//------------------------------------------------------------------------------
// RXgN^
Vector3Test::Vector3Test(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* Vector3Test::suite(){
	TestSuite* suite = new TestSuite("Vector3Test");
	suite->addTest(new TestCaller(Vector3Test, testConstructor));
	suite->addTest(new TestCaller(Vector3Test, testFixedNumber));
	suite->addTest(new TestCaller(Vector3Test, testSetValue));
	suite->addTest(new TestCaller(Vector3Test, testArithmetic));
	suite->addTest(new TestCaller(Vector3Test, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(Vector3Test, testVectorArithmetic));
	suite->addTest(new TestCaller(Vector3Test, testLength));
	suite->addTest(new TestCaller(Vector3Test, testLogicalOperation));
	suite->addTest(new TestCaller(Vector3Test, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void Vector3Test::testConstructor(){
	Vector3 vec0;
	TestEquals(12, (int)sizeof(vec0));
	vec0.x = 1.f;
	vec0.y = 2.f;
	vec0.z = 3.f;
	Vector3 vec1;
	vec1.array[0] = 1.f;
	vec1.array[1] = 2.f;
	vec1.array[2] = 3.f;
	TestAssert(vec0 == vec1);
	Vector3 vec2(1.f, 2.f, 3.f);
	TestAssert(vec0 == vec2);
	float array[] = { 1.f, 2.f, 3.f };
	Vector3 vec3((const float* const)array);
	TestAssert(vec0 == vec3);
	Vector3 vec4(vec0);
	TestAssert(vec0 == vec4);
	Vector3 vec5;
	vec5 = vec0;
	TestAssert(vec0 == vec5);
}
//------------------------------------------------------------------------------
// 萔eXg
void Vector3Test::testFixedNumber(){
	Vector3 vec0;
	vec0.set(0.f, 0.f, 0.f);
	TestAssert(vec0 == Vector3::zero);
	vec0.set(1.f, 0.f, 0.f);
	TestAssert(vec0 == Vector3::unitX);
	vec0.set(0.f, 1.f, 0.f);
	TestAssert(vec0 == Vector3::unitY);
	vec0.set(0.f, 0.f, 1.f);
	TestAssert(vec0 == Vector3::unitZ);
	vec0.set(1.f, 1.f, 1.f);
	TestAssert(vec0 == Vector3::unitScale);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void Vector3Test::testSetValue(){
	Vector3 vec0(1.f, 2.f, 3.f);
	Vector3 vec1;
	vec1.set(1.f, 2.f, 3.f);
	TestAssert(vec0 == vec1);
	float array[] = { 3.f, 2.f, 1.f };
	vec1.set(array);
	TestAssert(vec0 != vec1);
}
//------------------------------------------------------------------------------
// Z
void Vector3Test::testArithmetic(){
	const Vector3 vec0(0.f, 1.f, 2.f), vec1(1.f, 2.f, 3.f), vec2(1.f, 3.f, 5.f);
	TestAssert(vec2 == (vec0 + vec1));
	TestAssert(vec0 == (vec2 - vec1));
	const Vector3 vec3(0.f, 2.f, 4.f);
	TestAssert(vec3 == (vec0 * 2.f));
	TestAssert(vec3 == (2.f * vec0));
	TestAssert(vec0 == (+vec0));
	const Vector3 vec4(0.f, -1.f, -2.f);
	TestAssert(vec0 == (-vec4));
}
//------------------------------------------------------------------------------
// Z
void Vector3Test::testSubstitutionArithmetic(){
	Vector3 vec0(0.f, 1.f, 2.f), vec1(1.f, 1.f, 1.f);
	TestAssert(Vector3(1.f, 2.f, 3.f) == (vec0 += vec1));
	TestAssert(Vector3(0.f, 1.f, 2.f) == (vec0 -= vec1));
	TestAssert(Vector3(0.f, 2.f, 4.f) == (vec0 *= 2.f));
}
//------------------------------------------------------------------------------
// xNgZ
void Vector3Test::testVectorArithmetic(){
	Vector3 vec0 = Vector3::unitX, vec1 = Vector3::unitY, vec2 = -vec0;
	TestEquals(1.f, vec0.dotProduct(vec0));
	TestEquals(0.f, vec0.dotProduct(vec1));
	TestEquals(-1.f, vec0.dotProduct(vec2));
	TestAssert(Vector3::unitZ == vec0.crossProduct(vec1));
	TestAssert(vec0.crossProduct(vec0).isZero());
	TestAssert(vec0.crossProduct(vec2).isZero());
	vec0.x = 2.f;
	TestAssert(Vector3::unitZ == vec0.crossProduct(vec1).normalize());
}
//------------------------------------------------------------------------------
// ֘ÃeXg
void Vector3Test::testLength(){
	TestEquals(0.f, Vector3::zero.getLength());
	TestEquals(1.f, Vector3::unitX.getLength());
	Vector3 vec0(Vector3::unitScale);
	TestEquals(10.f, vec0.setLength(10.f).getLength());
	TestEpsilonEquals(100.f, vec0.getSquaredLength(), 0.00001f);
	TestEquals(1.f, vec0.normalize().getLength());
	vec0.set(0.f, 0.f, 1e-07f);
	TestAssert(vec0.isZero());
	vec0.set(0.f, 0.f, 2e-06f);
	TestAssert(!vec0.isZero());
	TestAssert(!vec0.isUnit());
	TestAssert(vec0.normalize() == Vector3::unitZ);
	TestAssert(vec0.isUnit());
}
//------------------------------------------------------------------------------
// _ZeXg
void Vector3Test::testLogicalOperation(){
	Vector3 vec0(0.f, 0.f, 0.f), vec1(1.f, 1.f, 1.f), vec2(0.f, 0.f, 0.f);
	TestAssert(!(vec0 == vec1));
	TestAssert(vec0 == vec2);
	TestAssert(vec0 != vec1);
	TestAssert(!(vec0 != vec2));
	TestAssert(vec0.epsilonEquals(vec1, 1.f));
	TestAssert(vec0 != vec1);
	TestAssert(vec0.notEpsilonEquals(vec1, 0.5f));
	TestAssert(!vec0.notEpsilonEquals(vec1, 1.f));
	TestAssert(!vec0.notEpsilonEquals(vec2, 0.f));
}
//------------------------------------------------------------------------------
// eXg
void Vector3Test::testToString(){
	Vector3 vec0(12345678.f, 1234.5678f, 0.12345678f);
	TestEquals("( 12345678.00000000, 1234.56774902, 0.12345678 )",
		vec0.toString());
}
//------------------------------------------------------------------------------
