//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OeNX`WeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/TexCoord3Test.h"
#include "Core/Primitive/TexCoord3.h"

//------------------------------------------------------------------------------
// RXgN^
TexCoord3Test::TexCoord3Test(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TexCoord3Test::suite(){
	TestSuite* suite = new TestSuite("TexCoord3Test");
	suite->addTest(new TestCaller(TexCoord3Test, testConstructor));
	suite->addTest(new TestCaller(TexCoord3Test, testFixedNumber));
	suite->addTest(new TestCaller(TexCoord3Test, testSetValue));
	suite->addTest(new TestCaller(TexCoord3Test, testArithmetic));
	suite->addTest(new TestCaller(TexCoord3Test, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(TexCoord3Test, testLogicalOperation));
	suite->addTest(new TestCaller(TexCoord3Test, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void TexCoord3Test::testConstructor(){
	TexCoord3 uv0;
	TestEquals(12, (int)sizeof(uv0));
	uv0.u = 1.f;
	uv0.v = 2.f;
	uv0.w = 3.f;
	TexCoord3 uv1;
	uv1.array[0] = 1.f;
	uv1.array[1] = 2.f;
	uv1.array[2] = 3.f;
	TestAssert(uv0 == uv1);
	TexCoord3 uv2(1.f, 2.f, 3.f);
	TestAssert(uv0 == uv2);
	float array[] = { 1.f, 2.f, 3.f };
	TexCoord3 uv3((const float* const)array);
	TestAssert(uv0 == uv3);
	TexCoord3 uv4(uv0);
	TestAssert(uv0 == uv4);
	TexCoord3 uv5;
	uv5 = uv0;
	TestAssert(uv0 == uv5);
}
//------------------------------------------------------------------------------
// 萔eXg
void TexCoord3Test::testFixedNumber(){
	TexCoord3 uv0;
	uv0.set(0.f, 0.f, 0.f);
	TestAssert(uv0 == TexCoord3::zero);
	uv0.set(1.f, 1.f, 1.f);
	TestAssert(uv0 == TexCoord3::unit);
	uv0.set(1.f, 0.f, 0.f);
	TestAssert(uv0 == TexCoord3::unitU);
	uv0.set(0.f, 1.f, 0.f);
	TestAssert(uv0 == TexCoord3::unitV);
	uv0.set(0.f, 0.f, 1.f);
	TestAssert(uv0 == TexCoord3::unitW);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void TexCoord3Test::testSetValue(){
	TexCoord3 uv0(1.f, 2.f, 3.f);
	TexCoord3 uv1;
	uv1.set(1.f, 2.f, 3.f);
	TestAssert(uv0 == uv1);
	float array[] = { 3.f, 2.f, 1.f };
	uv1.set(array);
	TestAssert(uv0 != uv1);
	uv0.set(3.f, 2.f, 1.f);
	TestAssert(uv0 == uv1);
}
//------------------------------------------------------------------------------
// Z
void TexCoord3Test::testArithmetic(){
	const TexCoord3 uv0(0.f, 1.f, 2.f), uv1(1.f, 2.f, 3.f), uv2(1.f, 3.f, 5.f);
	TestAssert(uv2 == (uv0 + uv1));
	TestAssert(uv0 == (uv2 - uv1));
	const TexCoord3 uv3(0.f, 2.f, 4.f);
	TestAssert(uv3 == (uv0 * 2.f));
	TestAssert(uv3 == (2.f * uv0));
	TestAssert(uv0 == (+uv0));
	const TexCoord3 uv4(0.f, -1.f, -2.f);
	TestAssert(uv0 == (-uv4));
}
//------------------------------------------------------------------------------
// Z
void TexCoord3Test::testSubstitutionArithmetic(){
	TexCoord3 uv0(0.f, 1.f, 2.f), uv1(1.f, 1.f, 1.f);
	TestAssert(TexCoord3(1.f, 2.f, 3.f) == (uv0 += uv1));
	TestAssert(TexCoord3(0.f, 1.f, 2.f) == (uv0 -= uv1));
	TestAssert(TexCoord3(0.f, 2.f, 4.f) == (uv0 *= 2.f));
}
//------------------------------------------------------------------------------
// _ZeXg
void TexCoord3Test::testLogicalOperation(){
	TexCoord3 uv0(0.f, 0.f, 0.f), uv1(1.f, 1.f, 1.f), uv2(0.f, 0.f, 0.f);
	TestAssert(!(uv0 == uv1));
	TestAssert(uv0 == uv2);
	TestAssert(uv0 != uv1);
	TestAssert(!(uv0 != uv2));
	TestAssert(uv0.epsilonEquals(uv1, 1.f));
	TestAssert(uv0.notEpsilonEquals(uv1, 0.5f));
	TestAssert(!uv0.notEpsilonEquals(uv1, 1.f));
	TestAssert(!uv0.notEpsilonEquals(uv2, 0.f));
}
//------------------------------------------------------------------------------
// eXg
void TexCoord3Test::testToString(){
	TexCoord3 uv0(12345678.f, 1234.5678f, 12.345678f);
	TestEquals("( 12345678.00000000, 1234.56774902, 12.34567833 )",
		uv0.toString());
}
//------------------------------------------------------------------------------
