//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 񎟌eNX`WeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/TexCoord2Test.h"
#include "Core/Primitive/TexCoord2.h"

//------------------------------------------------------------------------------
// RXgN^
TexCoord2Test::TexCoord2Test(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TexCoord2Test::suite(){
	TestSuite* suite = new TestSuite("TexCoord2Test");
	suite->addTest(new TestCaller(TexCoord2Test, testConstructor));
	suite->addTest(new TestCaller(TexCoord2Test, testFixedNumber));
	suite->addTest(new TestCaller(TexCoord2Test, testSetValue));
	suite->addTest(new TestCaller(TexCoord2Test, testArithmetic));
	suite->addTest(new TestCaller(TexCoord2Test, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(TexCoord2Test, testLogicalOperation));
	suite->addTest(new TestCaller(TexCoord2Test, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void TexCoord2Test::testConstructor(){
	TexCoord2 uv0;
	TestEquals(8, (int)sizeof(uv0));
	uv0.u = 1.f;
	uv0.v = 2.f;
	TexCoord2 uv1;
	uv1.array[0] = 1.f;
	uv1.array[1] = 2.f;
	TestAssert(uv0 == uv1);
	TexCoord2 uv2(1.f, 2.f);
	TestAssert(uv0 == uv2);
	float array[] = { 1.f, 2.f };
	TexCoord2 uv3((const float* const)array);
	TestAssert(uv0 == uv3);
	TexCoord2 uv4(uv0);
	TestAssert(uv0 == uv4);
	TexCoord2 uv5;
	uv5 = uv0;
	TestAssert(uv0 == uv5);
}
//------------------------------------------------------------------------------
// 萔eXg
void TexCoord2Test::testFixedNumber(){
	TexCoord2 uv0;
	uv0.set(0.f, 0.f);
	TestAssert(uv0 == TexCoord2::zero);
	uv0.set(1.f, 1.f);
	TestAssert(uv0 == TexCoord2::unit);
	uv0.set(1.f, 0.f);
	TestAssert(uv0 == TexCoord2::unitU);
	uv0.set(0.f, 1.f);
	TestAssert(uv0 == TexCoord2::unitV);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void TexCoord2Test::testSetValue(){
	TexCoord2 uv0(1.f, 2.f);
	TexCoord2 uv1;
	uv1.set(1.f, 2.f);
	TestAssert(uv0 == uv1);
	float array[] = { 3.f, 2.f };
	uv1.set(array);
	TestAssert(uv0 != uv1);
	uv0.set(3.f, 2.f);
	TestAssert(uv0 == uv1);
}
//------------------------------------------------------------------------------
// Z
void TexCoord2Test::testArithmetic(){
	const TexCoord2 uv0(0.f, 1.f), uv1(1.f, 2.f), uv2(1.f, 3.f);
	TestAssert(uv2 == (uv0 + uv1));
	TestAssert(uv0 == (uv2 - uv1));
	const TexCoord2 uv3(0.f, 2.f);
	TestAssert(uv3 == (uv0 * 2.f));
	TestAssert(uv3 == (2.f * uv0));
	TestAssert(uv0 == (+uv0));
	const TexCoord2 uv4(0.f, -1.f);
	TestAssert(uv0 == (-uv4));
}
//------------------------------------------------------------------------------
// Z
void TexCoord2Test::testSubstitutionArithmetic(){
	TexCoord2 uv0(0.f, 1.f), uv1(1.f, 1.f);
	TestAssert(TexCoord2(1.f, 2.f) == (uv0 += uv1));
	TestAssert(TexCoord2(0.f, 1.f) == (uv0 -= uv1));
	TestAssert(TexCoord2(0.f, 2.f) == (uv0 *= 2.f));
}
//------------------------------------------------------------------------------
// _ZeXg
void TexCoord2Test::testLogicalOperation(){
	TexCoord2 uv0(0.f, 0.f), uv1(1.f, 1.f), uv2(0.f, 0.f);
	TestAssert(!(uv0 == uv1));
	TestAssert(uv0 == uv2);
	TestAssert(uv0 != uv1);
	TestAssert(!(uv0 != uv2));
	TestAssert(uv0.epsilonEquals(uv1, 1.f));
	TestAssert(uv0.notEpsilonEquals(uv1, 0.5f));
	TestAssert(!uv0.notEpsilonEquals(uv1, 1.f));
	TestAssert(!uv0.notEpsilonEquals(uv2, 0.f));
}
//------------------------------------------------------------------------------
// eXg
void TexCoord2Test::testToString(){
	TexCoord2 uv0(12345678.f, 1234.5678f);
	TestEquals("( 12345678.00000000, 1234.56774902 )",
		uv0.toString());
}
//------------------------------------------------------------------------------
