//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ꎟeNX`WeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/TexCoord1Test.h"
#include "Core/Primitive/TexCoord1.h"

//------------------------------------------------------------------------------
// RXgN^
TexCoord1Test::TexCoord1Test(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TexCoord1Test::suite(){
	TestSuite* suite = new TestSuite("TexCoord1Test");
	suite->addTest(new TestCaller(TexCoord1Test, testConstructor));
	suite->addTest(new TestCaller(TexCoord1Test, testFixedNumber));
	suite->addTest(new TestCaller(TexCoord1Test, testSetValue));
	suite->addTest(new TestCaller(TexCoord1Test, testArithmetic));
	suite->addTest(new TestCaller(TexCoord1Test, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(TexCoord1Test, testLogicalOperation));
	suite->addTest(new TestCaller(TexCoord1Test, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void TexCoord1Test::testConstructor(){
	TexCoord1 uv0;
	TestEquals(4, (int)sizeof(uv0));
	uv0.u = 1.f;
	TexCoord1 uv1;
	uv1.array[0] = 1.f;
	TestAssert(uv0 == uv1);
	TexCoord1 uv2(1.f);
	TestAssert(uv0 == uv2);
	float array[] = { 1.f };
	TexCoord1 uv3((const float* const)array);
	TestAssert(uv0 == uv3);
	TexCoord1 uv4(uv0);
	TestAssert(uv0 == uv4);
	TexCoord1 uv5;
	uv5 = uv0;
	TestAssert(uv0 == uv5);
}
//------------------------------------------------------------------------------
// 萔eXg
void TexCoord1Test::testFixedNumber(){
	TexCoord1 uv0;
	uv0.set(0.f);
	TestAssert(uv0 == TexCoord1::zero);
	uv0.set(1.f);
	TestAssert(uv0 == TexCoord1::unit);
	uv0.set(1.f);
	TestAssert(uv0 == TexCoord1::unitU);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void TexCoord1Test::testSetValue(){
	TexCoord1 uv0(1.f);
	TexCoord1 uv1;
	uv1.set(1.f);
	TestAssert(uv0 == uv1);
	float array[] = { 3.f };
	uv1.set(array);
	TestAssert(uv0 != uv1);
	uv0.set(3.f);
	TestAssert(uv0 == uv1);
}
//------------------------------------------------------------------------------
// Z
void TexCoord1Test::testArithmetic(){
	const TexCoord1 uv0(0.f), uv1(1.f), uv2(1.f);
	TestAssert(uv2 == (uv0 + uv1));
	TestAssert(uv0 == (uv2 - uv1));
	const TexCoord1 uv3(2.f);
	TestAssert(uv3 == (uv1 * 2.f));
	TestAssert(uv3 == (2.f * uv1));
	TestAssert(uv0 == (+uv0));
	const TexCoord1 uv4(-1.f);
	TestAssert(uv2 == (-uv4));
}
//------------------------------------------------------------------------------
// Z
void TexCoord1Test::testSubstitutionArithmetic(){
	TexCoord1 uv0(0.f), uv1(1.f);
	TestAssert(TexCoord1(1.f) == (uv0 += uv1));
	TestAssert(TexCoord1(0.f) == (uv0 -= uv1));
	TestAssert(TexCoord1(0.f) == (uv0 *= 2.f));
}
//------------------------------------------------------------------------------
// _ZeXg
void TexCoord1Test::testLogicalOperation(){
	TexCoord1 uv0(0.f), uv1(1.f), uv2(0.f);
	TestAssert(!(uv0 == uv1));
	TestAssert(uv0 == uv2);
	TestAssert(uv0 != uv1);
	TestAssert(!(uv0 != uv2));
	TestAssert(uv0.epsilonEquals(uv1, 1.f));
	TestAssert(uv0.notEpsilonEquals(uv1, 0.5f));
	TestAssert(!uv0.notEpsilonEquals(uv1, 1.f));
	TestAssert(!uv0.notEpsilonEquals(uv2, 0.f));
}
//------------------------------------------------------------------------------
// eXg
void TexCoord1Test::testToString(){
	TexCoord1 uv0(12345678.f);
	TestEquals("( 12345678.00000000 )", uv0.toString());
}
//------------------------------------------------------------------------------
