//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/RectangleITest.h"
#include "Core/Primitive/RectangleI.h"
#include "Core/Primitive/RectangleF.h"

//------------------------------------------------------------------------------
// RXgN^
RectangleITest::RectangleITest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* RectangleITest::suite(){
	TestSuite* suite = new TestSuite("RectangleITest");
	suite->addTest(new TestCaller(RectangleITest, testConstructor));
	suite->addTest(new TestCaller(RectangleITest, testFixedNumber));
	suite->addTest(new TestCaller(RectangleITest, testSetValue));
	suite->addTest(new TestCaller(RectangleITest, testLogicalOperation));
	suite->addTest(new TestCaller(RectangleITest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void RectangleITest::testConstructor(){
	TestEquals(16, (int)sizeof(RectangleI));
	RectangleI rectangle0(16, 32, 64, 128);
	TestEquals(16, rectangle0.x);
	TestEquals(32, rectangle0.y);
	TestEquals(64, rectangle0.width);
	TestEquals(128, rectangle0.height);
	TestEquals(16, rectangle0.array[0]);
	TestEquals(32, rectangle0.array[1]);
	TestEquals(64, rectangle0.array[2]);
	TestEquals(128, rectangle0.array[3]);
	RectangleI rectangle1;
	rectangle1 = rectangle0;
	TestEquals(16, rectangle1.x);
	TestEquals(32, rectangle1.y);
	TestEquals(64, rectangle1.width);
	TestEquals(128, rectangle1.height);
	int array[] = { 16, 32, 64, 128 };
	RectangleI rectangle2(array);
	TestAssert(rectangle0 == rectangle2);
	RectangleI rectangle3(RectangleF(16.f, 32.f, 64.f, 128.f));
	TestAssert(RectangleI(16, 32, 64, 128) == rectangle3);
}
//------------------------------------------------------------------------------
// 萔eXg
void RectangleITest::testFixedNumber(){
	TestAssert(RectangleI(0, 0, 0, 0) == RectangleI::zero);
	TestAssert(RectangleI(0, 0, 1, 1) == RectangleI::unit);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void RectangleITest::testSetValue(){
	RectangleI rectangle0(0, 0, 0, 0);
	rectangle0.set(0, 0, 1, 1);
	TestAssert(RectangleI::unit == rectangle0);
	int array[] = { 0, 0, 0, 0 };
	rectangle0.set(array);
	TestAssert(RectangleI::zero == rectangle0);
	rectangle0.set(RectangleF(16.f, 32.f, 64.f, 128.f));
	TestAssert(RectangleI(16, 32, 64, 128) == rectangle0);
}
//------------------------------------------------------------------------------
// _ZeXg
void RectangleITest::testLogicalOperation(){
	RectangleI rectangle0(16, 32, 64, 128), rectangle1(16, 32, 64, 128);
	TestAssert(rectangle0 == rectangle1);
	TestAssert(!(rectangle0 != rectangle1));
	rectangle1.width = 96;
	TestAssert(!(rectangle0 == rectangle1));
	TestAssert(rectangle0 != rectangle1);
}
//------------------------------------------------------------------------------
// eXg
void RectangleITest::testToString(){
	RectangleI rectangle0(16, 32, 64, 128);
	TestEquals("( 16, 32, 64, 128 )", rectangle0.toString());
}
//------------------------------------------------------------------------------
