//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/RectangleFTest.h"
#include "Core/Primitive/RectangleF.h"
#include "Core/Primitive/RectangleI.h"

//------------------------------------------------------------------------------
// RXgN^
RectangleFTest::RectangleFTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* RectangleFTest::suite(){
	TestSuite* suite = new TestSuite("RectangleFTest");
	suite->addTest(new TestCaller(RectangleFTest, testConstructor));
	suite->addTest(new TestCaller(RectangleFTest, testFixedNumber));
	suite->addTest(new TestCaller(RectangleFTest, testSetValue));
	suite->addTest(new TestCaller(RectangleFTest, testLogicalOperation));
	suite->addTest(new TestCaller(RectangleFTest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void RectangleFTest::testConstructor(){
	TestEquals(16, (int)sizeof(RectangleF));
	RectangleF rectangle0(16.f, 32.f, 64.f, 128.f);
	TestEquals(16.f, rectangle0.x);
	TestEquals(32.f, rectangle0.y);
	TestEquals(64.f, rectangle0.width);
	TestEquals(128.f, rectangle0.height);
	TestEquals(16.f, rectangle0.array[0]);
	TestEquals(32.f, rectangle0.array[1]);
	TestEquals(64.f, rectangle0.array[2]);
	TestEquals(128.f, rectangle0.array[3]);
	RectangleF rectangle1;
	rectangle1 = rectangle0;
	TestEquals(16.f, rectangle1.x);
	TestEquals(32.f, rectangle1.y);
	TestEquals(64.f, rectangle1.width);
	TestEquals(128.f, rectangle1.height);
	float array[] = { 16.f, 32.f, 64.f, 128.f };
	RectangleF rectangle2(array);
	TestAssert(rectangle0 == rectangle2);
	RectangleF rectangle3(RectangleI(16, 32, 64, 128));
	TestAssert(RectangleF(16.f, 32.f, 64.f, 128.f) == rectangle3);
}
//------------------------------------------------------------------------------
// 萔eXg
void RectangleFTest::testFixedNumber(){
	TestAssert(RectangleF(0.f, 0.f, 0.f, 0.f) == RectangleF::zero);
	TestAssert(RectangleF(0.f, 0.f, 1.f, 1.f) == RectangleF::unit);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void RectangleFTest::testSetValue(){
	RectangleF rectangle0(0.f, 0.f, 0.f, 0.f);
	rectangle0.set(0.f, 0.f, 1.f, 1.f);
	TestAssert(RectangleF::unit == rectangle0);
	float array[] = { 0.f, 0.f, 0.f, 0.f };
	rectangle0.set(array);
	TestAssert(RectangleF::zero == rectangle0);
	rectangle0.set(RectangleI(16, 32, 64, 128));
	TestAssert(RectangleF(16.f, 32.f, 64.f, 128.f) == rectangle0);
}
//------------------------------------------------------------------------------
// _ZeXg
void RectangleFTest::testLogicalOperation(){
	RectangleF rectangle0(16.f, 32.f, 64.f, 128.f);
	RectangleF rectangle1(16.f, 32.f, 64.f, 128.f);
	TestAssert(rectangle0 == rectangle1);
	TestAssert(!(rectangle0 != rectangle1));
	rectangle1.width += Math::epsilon;
	TestAssert(rectangle0.epsilonEquals(rectangle1, Math::epsilon));
	TestAssert(!rectangle0.notEpsilonEquals(rectangle1, Math::epsilon));
	rectangle1.width += 0.0001f;
	TestAssert(!rectangle0.epsilonEquals(rectangle1, Math::epsilon));
	TestAssert(rectangle0.notEpsilonEquals(rectangle1, Math::epsilon));
	rectangle1.width = 96.f;
	TestAssert(!(rectangle0 == rectangle1));
	TestAssert(rectangle0 != rectangle1);
}
//------------------------------------------------------------------------------
// eXg
void RectangleFTest::testToString(){
	RectangleF rectangle0(16.f, 32.f, 64.f, 128.f);
	TestEquals("( 16.00000000, 32.00000000, 64.00000000, 128.00000000 )",
		rectangle0.toString());
}
//------------------------------------------------------------------------------
